/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Int8Box
extends NumberBox<Int8Box> {
    private byte value = 0;

    @Override
    public Int8Box newInstance() {
        return new Int8Box();
    }

    @Override
    public Int8Box init() {
        this.value = 0;
        return this;
    }

    @Override
    public Int8Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.byteValue();
        }
        return this;
    }

    @Override
    public Int8Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Int8Box.class ? ((Int8Box)otherBox).value : (Byte)otherBox.get();
        return this;
    }

    @Override
    public Byte get() {
        return this.value;
    }

    @Override
    public Int8Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Byte.parseByte(chars);
        return this;
    }

    @Override
    public Int8Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toByte();
        return this;
    }

    @Override
    public Encoder<Int8Box> getEncoder() {
        return new FixedLengthEncoder<Int8Box>(1);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putByte(this.value);
    }

    @Override
    public Bytes encode() {
        return Bytes.byteToBytes(this.value);
    }

    @Override
    public Int8Box decode(Bytes container) {
        this.value = container.decodeByte();
        return this;
    }

    @Override
    public Bytes toBytes() {
        return new Bytes(VarIntCodec.encode(this.value));
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Int8Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Int8Box set(short value) {
        this.value = (byte)value;
        return this;
    }

    @Override
    public Int8Box set(int value) {
        this.value = (byte)value;
        return this;
    }

    @Override
    public Int8Box set(long value) {
        this.value = (byte)value;
        return this;
    }

    @Override
    public Int8Box set(float value) {
        this.value = (byte)value;
        return this;
    }

    @Override
    public Int8Box set(double value) {
        this.value = (byte)value;
        return this;
    }
}

