/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import java.nio.charset.StandardCharsets;

public class StringBox
extends GenericBox<String, StringBox> {
    @Override
    public StringBox set(Bytes value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.length() == 0 ? "" : value.toString();
        }
        return this;
    }

    @Override
    public StringBox set(byte[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.length == 0 ? "" : new String(value, StandardCharsets.UTF_8);
        }
        return this;
    }

    @Override
    public StringBox newInstance() {
        return new StringBox();
    }

    @Override
    public StringBox char2Object(String chars) {
        if (chars == null) {
            this.init();
            return this;
        }
        this.value = chars;
        return this;
    }

    @Override
    public StringBox char2Object(Bytes chars, boolean detach) {
        if (chars == null) {
            this.init();
            return this;
        }
        this.value = chars.toString();
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        return container.putString((String)this.value, false);
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        return new Bytes((String)this.value);
    }

    @Override
    public StringBox decode(Bytes container) {
        this.value = container.toString();
        return this;
    }

    @Override
    public StringBox setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.toString();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((String)this.value).length() == 0) {
            return Bytes.EMPTY;
        }
        return new Bytes((String)this.value);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return (String)this.value;
    }
}

