/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.VarIntBox;

public class VarInt32Box
extends VarIntBox<Integer, VarInt32Box> {
    private int value = 0;

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public VarInt32Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt32Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt32Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt32Box set(long value) {
        this.value = (int)value;
        return this;
    }

    @Override
    public VarInt32Box set(float value) {
        this.value = (int)value;
        return this;
    }

    @Override
    public VarInt32Box set(double value) {
        this.value = (int)value;
        return this;
    }

    @Override
    public VarInt32Box newInstance() {
        return new VarInt32Box();
    }

    @Override
    public VarInt32Box init() {
        this.value = 0;
        return this;
    }

    @Override
    public VarInt32Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.intValue();
        }
        return this;
    }

    @Override
    public VarInt32Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == VarInt32Box.class ? ((VarInt32Box)otherBox).value : (Integer)otherBox.get();
        return this;
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public final VarInt32Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Integer.parseInt(chars);
        return this;
    }

    @Override
    public final VarInt32Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toInt();
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        return container.putVarInt32(this.value);
    }

    @Override
    public final Bytes encode() {
        return new Bytes(VarIntCodec.encode(this.value));
    }

    @Override
    public final VarInt32Box decode(Bytes container) {
        this.set(container.decodeVarInt32());
        return this;
    }

    @Override
    public final Bytes toBytes() {
        return new Bytes(ASCIIUtility.toASCII(this.value));
    }
}

