/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.VarIntBox;

public class VarInt64Box
extends VarIntBox<Long, VarInt64Box> {
    private long value = 0L;

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public VarInt64Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt64Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt64Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt64Box set(long value) {
        this.value = value;
        return this;
    }

    @Override
    public VarInt64Box set(float value) {
        this.value = (long)value;
        return this;
    }

    @Override
    public VarInt64Box set(double value) {
        this.value = (long)value;
        return this;
    }

    @Override
    public VarInt64Box newInstance() {
        return new VarInt64Box();
    }

    @Override
    public VarInt64Box init() {
        this.value = 0L;
        return this;
    }

    @Override
    public VarInt64Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.longValue();
        }
        return this;
    }

    @Override
    public VarInt64Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == VarInt64Box.class ? ((VarInt64Box)otherBox).value : (Long)otherBox.get();
        return this;
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public final VarInt64Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Long.parseLong(chars);
        return this;
    }

    @Override
    public final VarInt64Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toLong();
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        return container.putVarInt64(this.longValue());
    }

    @Override
    public final Bytes encode() {
        return new Bytes(VarIntCodec.encode(this.value));
    }

    @Override
    public final VarInt64Box decode(Bytes container) {
        this.set(container.decodeVarInt64());
        return this;
    }

    @Override
    public final Bytes toBytes() {
        return new Bytes(ASCIIUtility.toASCII(this.value));
    }
}

