/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.decoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.basic.BooleanBox;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.Assert;

public enum BooleanDecoder implements Decoder<BooleanBox>
{
    INSTANCE;


    @Override
    public int decodeTo(Bytes cache, LinkedObjectPool<BooleanBox> container) {
        if (cache == null || cache.length() == 0) {
            return 0;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        int offset = container.size();
        container.require(num);
        if (num > 0) {
            byte code = reader.getByte();
            int index = 0;
            for (int i = 0; i < num; ++i) {
                int bitIndex;
                container.fastGet(offset + i).set((code >> (bitIndex = 7 - (i & 7)) & 1) == 1);
                if (++index != 8 || i == num - 1) continue;
                code = reader.getByte();
                index = 0;
            }
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return num;
    }

    @Override
    public Object[] decodeTo(Bytes cache, BooleanBox box) {
        if (cache == null || cache.length() == 0) {
            return EmptyArray.OBJECT;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        Object[] container = new Object[num];
        if (num > 0) {
            byte code = reader.getByte();
            int index = 0;
            for (int i = 0; i < num; ++i) {
                int bitIndex = 7 - (i & 7);
                container[i] = (code >> bitIndex & 1) == 1;
                if (++index != 8 || i == num - 1) continue;
                code = reader.getByte();
                index = 0;
            }
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return container;
    }
}

