/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.decoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.Assert;

public enum FixedLengthDecoder implements Decoder<Box<?, ?>>
{
    INSTANCE;


    @Override
    public int decodeTo(Bytes cache, LinkedObjectPool<Box<?, ?>> container) {
        if (cache == null || cache.length() == 0) {
            return 0;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength <= 511 && fixedLength > 0);
        int offset = container.size();
        container.require(num);
        Bytes wrapper = new Bytes();
        if (num > 0) {
            int i;
            int dupCount = num - (cache.length() - 4) / fixedLength;
            reader.getBytes(wrapper, fixedLength);
            container.fastGet(offset).decode(wrapper);
            for (i = 1; i < 1 + dupCount; ++i) {
                container.fastGet(offset + i).setValueFrom(container.fastGet(offset));
            }
            for (i = dupCount + 1; i < num; ++i) {
                reader.getBytes(wrapper, fixedLength);
                container.fastGet(offset + i).decode(wrapper);
            }
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        wrapper.reset();
        reader.close();
        return num;
    }

    @Override
    public Object[] decodeTo(Bytes cache, Box<?, ?> box) {
        if (cache == null || cache.length() == 0) {
            return EmptyArray.OBJECT;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength <= 511 && fixedLength > 0);
        Object[] container = new Object[num];
        Bytes wrapper = new Bytes();
        if (num > 0) {
            int i;
            int dupCount = num - (cache.length() - 4) / fixedLength;
            reader.getBytes(wrapper, fixedLength);
            container[0] = ((Box)box.decode(wrapper)).get();
            for (i = 1; i < 1 + dupCount; ++i) {
                container[i] = container[0];
            }
            for (i = 1 + dupCount; i < num; ++i) {
                reader.getBytes(wrapper, fixedLength);
                container[i] = ((Box)box.decode(wrapper)).get();
            }
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        wrapper.reset();
        reader.close();
        return container;
    }
}

