/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.decoder;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.Assert;

public enum NullDecoder implements Decoder<Box<?, ?>>
{
    INSTANCE;


    @Override
    public int decodeTo(Bytes cache, LinkedObjectPool<Box<?, ?>> container) {
        if (cache == null || cache.length() == 0) {
            return 0;
        }
        if (cache.length() != 4) {
            throw new CCFCodingException("Invalid input length");
        }
        int flag = Decoder.flag(cache.toByteStream());
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        int offset = container.size();
        container.require(num);
        for (int i = 0; i < num; ++i) {
            container.fastGet(offset + i).init();
        }
        return num;
    }

    @Override
    public Object[] decodeTo(Bytes cache, Box<?, ?> box) {
        if (cache == null || cache.length() == 0) {
            return EmptyArray.OBJECT;
        }
        if (cache.length() != 4) {
            throw new CCFCodingException("Invalid input length");
        }
        int flag = Decoder.flag(cache.toByteStream());
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        box.init();
        Object[] returns = new Object[num];
        for (int i = 0; i < num; ++i) {
            returns[i] = box.get();
        }
        return returns;
    }
}

