/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.decoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.Assert;

public enum SharedDynamicLengthDecoder implements Decoder<Box<?, ?>>
{
    INSTANCE;


    @Override
    public int decodeTo(Bytes cache, LinkedObjectPool<Box<?, ?>> container) {
        if (cache == null || cache.length() == 0) {
            return 0;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        int offset = container.size();
        container.require(num);
        Bytes wrapper = new Bytes();
        for (int i = 0; i < num; ++i) {
            int status = reader.getVarInt32();
            if (status == 0) {
                container.fastGet(offset + i).decode(Bytes.EMPTY);
                continue;
            }
            if (status == -1) {
                container.fastGet(offset + i).init();
                continue;
            }
            if (status > 0) {
                reader.getBytes(wrapper, status);
                container.fastGet(offset + i).decode(wrapper);
                continue;
            }
            Box<?, ?> lastBox = container.fastGet(offset + i - 1);
            for (int j = 0; j < -status - 1; ++j) {
                container.fastGet(offset + i).setValueFrom(lastBox);
                ++i;
            }
            --i;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        wrapper.reset();
        reader.close();
        return num;
    }

    @Override
    public Object[] decodeTo(Bytes cache, Box<?, ?> box) {
        if (cache == null || cache.length() == 0) {
            return EmptyArray.OBJECT;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        Object[] container = new Object[num];
        Bytes wrapper = new Bytes();
        for (int i = 0; i < num; ++i) {
            int status = reader.getVarInt32();
            if (status == 0) {
                container[i] = ((Box)box.decode(Bytes.EMPTY)).get();
                continue;
            }
            if (status == -1) {
                container[i] = ((Box)box.init()).get();
                continue;
            }
            if (status > 0) {
                reader.getBytes(wrapper, status);
                container[i] = ((Box)box.decode(wrapper)).get();
                continue;
            }
            for (int j = 0; j < -status - 1; ++j) {
                container[i] = box.get();
                ++i;
            }
            --i;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        wrapper.reset();
        reader.close();
        return container;
    }
}

