/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.decoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.basic.VarIntBox;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.Assert;

public enum VarIntDecoder implements Decoder<VarIntBox<?, ?>>
{
    INSTANCE;


    @Override
    public int decodeTo(Bytes cache, LinkedObjectPool<VarIntBox<?, ?>> container) {
        if (cache == null || cache.length() == 0) {
            return 0;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        int offset = container.size();
        container.require(num);
        long lastValue = 0L;
        for (int i = 0; i < num; ++i) {
            long currentValue = lastValue + reader.getVarInt64();
            container.fastGet(offset + i).set(currentValue);
            lastValue = currentValue;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return num;
    }

    @Override
    public Object[] decodeTo(Bytes cache, VarIntBox<?, ?> box) {
        if (cache == null || cache.length() == 0) {
            return EmptyArray.OBJECT;
        }
        ByteStream reader = cache.toByteStream();
        int flag = Decoder.flag(reader);
        int num = Decoder.length(flag);
        int fixedLength = Decoder.fixedLength(flag);
        Assert.that(fixedLength == 0);
        Object[] container = new Object[num];
        long lastValue = 0L;
        for (int i = 0; i < num; ++i) {
            long currentValue = lastValue + reader.getVarInt64();
            container[i] = ((VarIntBox)box.set(currentValue)).get();
            lastValue = currentValue;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return container;
    }
}

