/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.encoder;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.basic.BooleanBox;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;

public class BooleanEncoder
extends Encoder<BooleanBox> {
    int code = 0;
    int index = 0;

    public BooleanEncoder() {
        super(0, true);
    }

    @Override
    public int encode(boolean value) {
        this.code = value ? this.code << 1 | 1 : (this.code <<= 1);
        ++this.index;
        ++this.elementNum;
        if (this.index == 8) {
            this.cache.write(this.code);
            this.index = 0;
            this.code = 0;
            return 1;
        }
        return 0;
    }

    @Override
    public int encode(BooleanBox value) {
        return this.encode(value.booleanValue());
    }

    @Override
    public Bytes flush() {
        if (this.index != 0) {
            this.cache.putByte((byte)(this.code << 8 - this.index));
        }
        try {
            Bytes bytes = super.flush();
            return bytes;
        }
        finally {
            this.index = 0;
            this.code = 0;
        }
    }
}

