/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;

public class DynamicLengthEncoder<T extends Box<?, T>>
extends Encoder<T> {
    final StateMachine<T> machine;

    public DynamicLengthEncoder() {
        super(0);
        this.machine = new StateMachine(this.cache);
    }

    @Override
    public int encode(T value) {
        int length = this.machine.update(value);
        ++this.elementNum;
        return length;
    }

    @Override
    public Bytes flush() {
        this.machine.flush();
        return super.flush();
    }

    @Override
    public void close() {
        super.close();
        this.machine.close();
    }

    private static class StateMachine<T extends Box<?, T>> {
        final ByteStream output;
        final Frame frame = new Frame();
        final ByteStream codec = new ByteStream();

        public StateMachine(ByteStream output) {
            this.output = output;
        }

        public int update(T value) {
            if (this.frame.type == TYPE.INIT) {
                if (value == null || ((Box)value).isNull()) {
                    this.frame.type = TYPE.NULL;
                    this.frame.count = 1;
                    return this.output.putVarInt32(-1);
                }
                this.codec.clear();
                ((Box)value).encodeTo(this.codec);
                int length = this.output.putVarInt32(this.codec.length());
                this.frame.type = TYPE.DATA;
                this.frame.count = 1;
                this.frame.data.reset(this.output.bytes(), this.output.end() - this.codec.length(), this.codec.length());
                return length += this.output.write(this.codec.bytes(), this.codec.offset(), this.codec.length());
            }
            if (this.frame.type == TYPE.NULL) {
                if (value == null || ((Box)value).isNull()) {
                    ++this.frame.count;
                    return 0;
                }
                int length = this.flush();
                this.codec.clear();
                ((Box)value).encodeTo(this.codec);
                length += this.output.putVarInt32(this.codec.length());
                this.frame.type = TYPE.DATA;
                this.frame.count = 1;
                this.frame.data.reset(this.output.bytes(), this.output.end() - this.codec.length(), this.codec.length());
                return length += this.output.write(this.codec.bytes(), this.codec.offset(), this.codec.length());
            }
            if (value == null || ((Box)value).isNull()) {
                int length = this.flush();
                this.frame.type = TYPE.NULL;
                this.frame.count = 1;
                return length + this.output.putVarInt32(-1);
            }
            this.codec.clear();
            ((Box)value).encodeTo(this.codec);
            if (this.frame.data.valueEquals(this.codec)) {
                ++this.frame.count;
                return 0;
            }
            int length = this.flush();
            length += this.output.putVarInt32(this.codec.length());
            this.frame.type = TYPE.DATA;
            this.frame.count = 1;
            this.frame.data.reset(this.output.bytes(), this.output.end() - this.codec.length(), this.codec.length());
            return length += this.output.write(this.codec.bytes(), this.codec.offset(), this.codec.length());
        }

        public int flush() {
            int length = 0;
            if (this.frame.type != TYPE.INIT && this.frame.count > 1) {
                length += this.output.putVarInt32(-this.frame.count);
            }
            this.frame.clear();
            return length;
        }

        public void close() {
            this.frame.clear();
            this.codec.close();
        }
    }

    static class Frame {
        final Bytes data = new Bytes();
        TYPE type = TYPE.INIT;
        int count = 0;

        Frame() {
        }

        public void clear() {
            this.count = 0;
            this.type = TYPE.INIT;
            this.data.reset();
        }
    }

    static enum TYPE {
        INIT,
        NULL,
        DATA;

    }
}

