/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;

public abstract class Encoder<T extends Box<?, T>> {
    final ByteStream cache = new ByteStream();
    final Bytes container;
    final int fixedLength;
    int elementNum = 0;

    public Encoder(int fixedLength) {
        this(fixedLength, true);
    }

    public Encoder(int fixedLength, boolean share) {
        if (fixedLength > 511 || fixedLength < 0) {
            throw new CCFCodingException("The FixedLengthEncoder requires that the length of each element does not exceed 511 and is not less than 0");
        }
        this.fixedLength = fixedLength;
        this.container = share ? new Bytes() : null;
    }

    public abstract int encode(T var1);

    public Bytes flush() {
        if (this.elementNum >= 0x800000) {
            throw new CCFCodingException("The maximum number of elements allowed for the encoder is 8388607");
        }
        this.cache.putInt(this.fixedLength << 23 | this.elementNum);
        Bytes codec = this.container != null ? this.cache.toBytes(this.container) : this.cache.toBytes(true);
        this.elementNum = 0;
        this.cache.clear();
        return codec;
    }

    public void close() {
        this.elementNum = 0;
        this.cache.close();
        if (this.container != null) {
            this.container.reset();
        }
    }
}

