/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.encoder;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;

public class FixedLengthEncoder<T extends Box<?, T>>
extends Encoder<T> {
    public FixedLengthEncoder(int fixedLength) {
        super(fixedLength);
        if (fixedLength > 511 || fixedLength < 1) {
            throw new CCFCodingException("The FixedLengthEncoder requires that the length of each element does not exceed 511 and is not less than 1");
        }
    }

    @Override
    public int encode(T value) {
        int length = ((Box)value).encodeTo(this.cache);
        if (length != this.fixedLength) {
            throw new CCFCodingException("Invalid input length");
        }
        ++this.elementNum;
        return length;
    }

    @Override
    public Bytes flush() {
        if (this.elementNum >= 0x800000) {
            throw new CCFCodingException("The maximum number of elements allowed for the encoder is 8388607");
        }
        int count = 0;
        if (this.elementNum > 0) {
            byte[] codes = this.cache.bytes();
            int index = this.fixedLength;
            block0: for (int i = 1; i < this.elementNum; ++i) {
                for (int j = 0; j < this.fixedLength; ++j) {
                    if (codes[j] != codes[index++]) break block0;
                }
                ++count;
            }
        }
        this.cache.putInt(this.fixedLength << 23 | this.elementNum);
        Bytes codec = this.container != null ? this.cache.toBytes(this.container) : this.cache.toBytes(true);
        this.elementNum = 0;
        this.cache.clear();
        if (count > 0) {
            int off = count * this.fixedLength;
            codec.reset(codec.offset() + off, codec.length() - off);
        }
        return codec;
    }
}

