/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.encoder;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.basic.VarIntBox;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;

public class VarIntEncoder<K, T extends VarIntBox<K, T>>
extends Encoder<T> {
    long lastValue = 0L;

    public VarIntEncoder() {
        super(0, true);
    }

    @Override
    public int encode(long currentValue) {
        int length = this.cache.putVarInt64(currentValue - this.lastValue);
        this.lastValue = currentValue;
        ++this.elementNum;
        return length;
    }

    @Override
    public int encode(T value) {
        return this.encode(((NumberBox)value).longValue());
    }

    @Override
    public Bytes flush() {
        try {
            Bytes bytes = super.flush();
            return bytes;
        }
        finally {
            this.lastValue = 0L;
        }
    }
}

