/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.interval;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.interval.DoubleInterval;

public class DoubleIntervalBox
extends GenericBox<DoubleInterval, DoubleIntervalBox> {
    public DoubleIntervalBox set(double min, double max) {
        this.value = new DoubleInterval(min, max);
        return this;
    }

    @Override
    public DoubleIntervalBox newInstance() {
        return new DoubleIntervalBox();
    }

    @Override
    public DoubleIntervalBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
        } else {
            int index = chars.indexOf("~");
            this.value = index != -1 ? (index == 0 ? (chars.length() == 1 ? new DoubleInterval(Double.NaN, Double.NaN) : new DoubleInterval(Double.NaN, Double.parseDouble(chars.substring(index + 1)))) : (index == chars.length() - 1 ? new DoubleInterval(Double.parseDouble(chars.substring(0, index)), Double.NaN) : new DoubleInterval(Double.parseDouble(chars.substring(0, index)), Double.parseDouble(chars.substring(index + 1))))) : new DoubleInterval(Double.parseDouble(chars), Double.NaN);
        }
        return this;
    }

    @Override
    public DoubleIntervalBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        int index = chars.indexOf((byte)126);
        this.value = index != -1 ? (index == 0 ? (chars.length() == 1 ? new DoubleInterval(Double.NaN, Double.NaN) : new DoubleInterval(Double.NaN, chars.subBytes(index + 1).toDouble())) : (index == chars.length() - 1 ? new DoubleInterval(chars.subBytes(0, index).toDouble(), Double.NaN) : new DoubleInterval(chars.subBytes(0, index).toDouble(), chars.subBytes(index + 1).toDouble()))) : new DoubleInterval(chars.toDouble(), Double.NaN);
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        return container.putDouble(((DoubleInterval)this.value).start()) + container.putDouble(((DoubleInterval)this.value).end());
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putDouble(((DoubleInterval)this.value).start());
        container.putDouble(((DoubleInterval)this.value).end());
        return container.toBytes(true);
    }

    @Override
    public DoubleIntervalBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        if (container.length() != 16) {
            throw new CCFCodingException("Invalid input length");
        }
        ByteStream reader = container.toByteStream();
        this.value = new DoubleInterval(reader.getDouble(), reader.getDouble());
        reader.close();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        if (Double.isNaN(((DoubleInterval)this.value).start())) {
            if (Double.isNaN(((DoubleInterval)this.value).end())) {
                return Bytes.byteToBytes((byte)126);
            }
            ByteStream builder = ((ByteStream)temps.get()).clear();
            builder.write(126);
            builder.writeChar(((DoubleInterval)this.value).end());
            return builder.toBytes(true);
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        if (Double.isNaN(((DoubleInterval)this.value).end())) {
            builder.writeChar(((DoubleInterval)this.value).start());
            builder.write(126);
        } else {
            builder.writeChar(((DoubleInterval)this.value).start());
            builder.write(126);
            builder.writeChar(((DoubleInterval)this.value).end());
        }
        return builder.toBytes(true);
    }
}

