/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.interval;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.interval.FloatInterval;

public class FloatIntervalBox
extends GenericBox<FloatInterval, FloatIntervalBox> {
    public FloatIntervalBox set(float min, float max) {
        this.value = new FloatInterval(min, max);
        return this;
    }

    @Override
    public FloatIntervalBox newInstance() {
        return new FloatIntervalBox();
    }

    @Override
    public FloatIntervalBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
        } else {
            int index = chars.indexOf("~");
            this.value = index != -1 ? (index == 0 ? (chars.length() == 1 ? new FloatInterval(Float.NaN, Float.NaN) : new FloatInterval(Float.NaN, Float.parseFloat(chars.substring(index + 1)))) : (index == chars.length() - 1 ? new FloatInterval(Float.parseFloat(chars.substring(0, index)), Float.NaN) : new FloatInterval(Float.parseFloat(chars.substring(0, index)), Float.parseFloat(chars.substring(index + 1))))) : new FloatInterval(Float.parseFloat(chars), Float.NaN);
        }
        return this;
    }

    @Override
    public FloatIntervalBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        int index = chars.indexOf((byte)126);
        this.value = index != -1 ? (index == 0 ? (chars.length() == 1 ? new FloatInterval(Float.NaN, Float.NaN) : new FloatInterval(Float.NaN, chars.subBytes(index + 1).toFloat())) : (index == chars.length() - 1 ? new FloatInterval(chars.subBytes(0, index).toFloat(), Float.NaN) : new FloatInterval(chars.subBytes(0, index).toFloat(), chars.subBytes(index + 1).toFloat()))) : new FloatInterval(chars.toFloat(), Float.NaN);
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        return container.putFloat(((FloatInterval)this.value).start()) + container.putFloat(((FloatInterval)this.value).end());
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putFloat(((FloatInterval)this.value).start());
        container.putFloat(((FloatInterval)this.value).end());
        return container.toBytes(true);
    }

    @Override
    public FloatIntervalBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        if (container.length() != 8) {
            throw new CCFCodingException("Invalid input length");
        }
        ByteStream reader = container.toByteStream();
        this.value = new FloatInterval(reader.getFloat(), reader.getFloat());
        reader.close();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        if (Double.isNaN(((FloatInterval)this.value).start())) {
            if (Double.isNaN(((FloatInterval)this.value).end())) {
                return Bytes.byteToBytes((byte)126);
            }
            ByteStream builder = ((ByteStream)temps.get()).clear();
            builder.write(126);
            builder.writeChar(((FloatInterval)this.value).end());
            return builder.toBytes(true);
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        if (Double.isNaN(((FloatInterval)this.value).end())) {
            builder.writeChar(((FloatInterval)this.value).start());
            builder.write(126);
        } else {
            builder.writeChar(((FloatInterval)this.value).start());
            builder.write(126);
            builder.writeChar(((FloatInterval)this.value).end());
        }
        return builder.toBytes(true);
    }
}

