/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TDoubleIterator;

public class Float64ListBox
extends GenericBox<DoubleList, Float64ListBox> {
    @Override
    public Float64ListBox set(float value) {
        this.value = new DoubleList(1);
        ((DoubleList)this.value).add(value);
        return this;
    }

    @Override
    public Float64ListBox set(float[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new DoubleList(value.length);
            for (float v : value) {
                ((DoubleList)this.value).add(v);
            }
        }
        return this;
    }

    @Override
    public Float64ListBox newInstance() {
        return new Float64ListBox();
    }

    @Override
    public Float64ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        DoubleList returns = new DoubleList(ValueUtils.count(chars, ','));
        while (values2.hasNext()) {
            returns.add(Double.parseDouble(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public Float64ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        DoubleList returns = new DoubleList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toDouble());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((DoubleList)this.value).size());
        int l = ((DoubleList)this.value).size();
        for (int i = 0; i < l; ++i) {
            length += container.putDouble(((DoubleList)this.value).fastGet(i));
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((DoubleList)this.value).size());
        int l = ((DoubleList)this.value).size();
        for (int i = 0; i < l; ++i) {
            container.putDouble(((DoubleList)this.value).fastGet(i));
        }
        return container.toBytes(true);
    }

    @Override
    public Float64ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        DoubleList returns = new DoubleList(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getDouble());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((DoubleList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TDoubleIterator iterator2 = ((DoubleList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

