/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.ccf.type.basic.Float8Box;
import edu.sysu.pmglab.container.list.FloatList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TFloatIterator;

public class Float8ListBox
extends GenericBox<FloatList, Float8ListBox> {
    private final Float8Box box = new Float8Box();

    @Override
    public final Float8ListBox set(float value) {
        this.value = new FloatList(1);
        ((FloatList)this.value).add(value);
        return this;
    }

    @Override
    public final Float8ListBox set(float[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = FloatList.wrap(value);
        }
        return this;
    }

    @Override
    public Float8ListBox newInstance() {
        return new Float8ListBox();
    }

    @Override
    public final Float8ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        FloatList returns = new FloatList(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Float.parseFloat(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final Float8ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        FloatList returns = new FloatList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toFloat());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((FloatList)this.value).size());
        int l = ((FloatList)this.value).size();
        for (int i = 0; i < l; ++i) {
            length += this.box.set(((FloatList)this.value).fastGet(i)).encodeTo(container);
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((FloatList)this.value).size());
        int l = ((FloatList)this.value).size();
        for (int i = 0; i < l; ++i) {
            this.box.set(((FloatList)this.value).fastGet(i)).encodeTo(container);
        }
        return container.toBytes(true);
    }

    @Override
    public Float8ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        FloatList returns = new FloatList(size);
        for (int i = 0; i < size; ++i) {
            returns.add(this.box.decode(reader.getByte()).floatValue());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((FloatList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TFloatIterator iterator2 = ((FloatList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

