/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.ShortList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TShortIterator;

public class Int16ListBox
extends GenericBox<ShortList, Int16ListBox> {
    @Override
    public Int16ListBox set(short value) {
        this.value = new ShortList(1);
        ((ShortList)this.value).add(value);
        return this;
    }

    @Override
    public Int16ListBox set(short[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = ShortList.wrap(value);
        }
        return this;
    }

    @Override
    public Int16ListBox newInstance() {
        return new Int16ListBox();
    }

    @Override
    public Int16ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        ShortList returns = new ShortList(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Short.parseShort(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public Int16ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        ShortList returns = new ShortList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toShort());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((ShortList)this.value).size());
        int l = ((ShortList)this.value).size();
        for (int i = 0; i < l; ++i) {
            length += container.putShort(((ShortList)this.value).fastGet(i));
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((ShortList)this.value).size());
        int l = ((ShortList)this.value).size();
        for (int i = 0; i < l; ++i) {
            container.putShort(((ShortList)this.value).fastGet(i));
        }
        return container.toBytes(true);
    }

    @Override
    public Int16ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        ShortList returns = new ShortList(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getShort());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((ShortList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TShortIterator iterator2 = ((ShortList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

