/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TIntIterator;

public class Int32ListBox
extends GenericBox<IntList, Int32ListBox> {
    @Override
    public Int32ListBox set(int value) {
        this.value = new IntList(1);
        ((IntList)this.value).add(value);
        return this;
    }

    @Override
    public Int32ListBox set(int[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = IntList.wrap(value);
        }
        return this;
    }

    @Override
    public Int32ListBox newInstance() {
        return new Int32ListBox();
    }

    @Override
    public Int32ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        IntList returns = new IntList(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Integer.parseInt(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public Int32ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        IntList returns = new IntList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toInt());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((IntList)this.value).size());
        int lastValue = 0;
        int l = ((IntList)this.value).size();
        for (int i = 0; i < l; ++i) {
            int value = ((IntList)this.value).fastGet(i);
            length += container.putVarInt32(value - lastValue);
            lastValue = value;
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((IntList)this.value).size());
        int lastValue = 0;
        int l = ((IntList)this.value).size();
        for (int i = 0; i < l; ++i) {
            int value = ((IntList)this.value).fastGet(i);
            container.putVarInt32(value - lastValue);
            lastValue = value;
        }
        return container.toBytes(true);
    }

    @Override
    public Int32ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        IntList returns = new IntList(size);
        int lastValue = 0;
        for (int i = 0; i < size; ++i) {
            int value = lastValue + reader.getVarInt32();
            returns.add(value);
            lastValue = value;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((IntList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TIntIterator iterator2 = ((IntList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

