/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TLongIterator;

public class Int64ListBox
extends GenericBox<LongList, Int64ListBox> {
    @Override
    public Int64ListBox set(int value) {
        this.value = new LongList(1);
        ((LongList)this.value).add(value);
        return this;
    }

    @Override
    public Int64ListBox set(long value) {
        this.value = new LongList(1);
        ((LongList)this.value).add(value);
        return this;
    }

    @Override
    public Int64ListBox set(long[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = LongList.wrap(value);
        }
        return this;
    }

    @Override
    public Int64ListBox set(int[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new LongList(value.length);
            for (int v : value) {
                ((LongList)this.value).add(v);
            }
        }
        return this;
    }

    @Override
    public Int64ListBox newInstance() {
        return new Int64ListBox();
    }

    @Override
    public Int64ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        LongList returns = new LongList(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Long.parseLong(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public Int64ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        LongList returns = new LongList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toLong());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((LongList)this.value).size());
        long lastValue = 0L;
        int l = ((LongList)this.value).size();
        for (int i = 0; i < l; ++i) {
            long value = ((LongList)this.value).fastGet(i);
            length += container.putVarInt64(value - lastValue);
            lastValue = value;
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt64(((LongList)this.value).size());
        long lastValue = 0L;
        int l = ((LongList)this.value).size();
        for (int i = 0; i < l; ++i) {
            long value = ((LongList)this.value).fastGet(i);
            container.putVarInt64(value - lastValue);
            lastValue = value;
        }
        return container.toBytes(true);
    }

    @Override
    public Int64ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        LongList returns = new LongList(size);
        long lastValue = 0L;
        for (int i = 0; i < size; ++i) {
            long value = lastValue + reader.getVarInt64();
            returns.add(value);
            lastValue = value;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((LongList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TLongIterator iterator2 = ((LongList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

