/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.ByteList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TByteIterator;

public class Int8ListBox
extends GenericBox<ByteList, Int8ListBox> {
    @Override
    public Int8ListBox set(byte value) {
        this.value = new ByteList(1);
        ((ByteList)this.value).add(value);
        return this;
    }

    @Override
    public Int8ListBox set(byte[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = ByteList.wrap(value);
        }
        return this;
    }

    @Override
    public Int8ListBox newInstance() {
        return new Int8ListBox();
    }

    @Override
    public Int8ListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        ByteList returns = new ByteList(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Byte.parseByte(values2.next()));
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public Int8ListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        ByteList returns = new ByteList(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toByte());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((ByteList)this.value).size());
        int l = ((ByteList)this.value).size();
        for (int i = 0; i < l; ++i) {
            length += container.putByte(((ByteList)this.value).fastGet(i));
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((ByteList)this.value).size());
        int l = ((ByteList)this.value).size();
        for (int i = 0; i < l; ++i) {
            container.putByte(((ByteList)this.value).fastGet(i));
        }
        return container.toBytes(true);
    }

    @Override
    public Int8ListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        ByteList returns = new ByteList(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getByte());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((ByteList)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TByteIterator iterator2 = ((ByteList)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

