/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ValueUtils;

public class ListBox<V>
extends GenericBox<List<V>, ListBox<V>> {
    private final Box<V, ?> elementBox;

    public ListBox(Box<V, ?> element) {
        this.elementBox = element;
    }

    @Override
    public final ListBox<V> set(V[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = List.wrap(value);
        }
        return this;
    }

    @Override
    public ListBox<V> newInstance() {
        return new ListBox<V>(this.elementBox.newInstance());
    }

    @Override
    public final ListBox<V> char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        List returns = new List(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(((Box)this.elementBox.char2Object(values2.next())).get());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final ListBox<V> char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        List returns = new List(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(((Box)this.elementBox.char2Object(values2.next(), detach)).get());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((List)this.value).size());
        ByteStream elementEncodedContainer = new ByteStream();
        for (Object value : (List)this.value) {
            this.elementBox.set(value);
            if (this.elementBox.isNull()) {
                length += container.putVarInt32(-1);
                continue;
            }
            elementEncodedContainer.clear();
            this.elementBox.encodeTo(elementEncodedContainer);
            length += container.putVarInt32(elementEncodedContainer.length());
            length += container.write(elementEncodedContainer.bytes(), elementEncodedContainer.offset(), elementEncodedContainer.length());
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = new ByteStream();
        ByteStream elementEncodedContainer = new ByteStream();
        container.putVarInt32(((List)this.value).size());
        for (Object value : (List)this.value) {
            this.elementBox.set(value);
            if (this.elementBox.isNull()) {
                container.putVarInt32(-1);
                continue;
            }
            elementEncodedContainer.clear();
            this.elementBox.encodeTo(elementEncodedContainer);
            container.putVarInt32(elementEncodedContainer.length());
            container.write(elementEncodedContainer.bytes(), elementEncodedContainer.offset(), elementEncodedContainer.length());
        }
        elementEncodedContainer.close();
        return container.toBytes(false);
    }

    @Override
    public final ListBox<V> decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        Bytes wrapper = new Bytes();
        int size = reader.getVarInt32();
        List returns = new List(size);
        for (int i = 0; i < size; ++i) {
            int length = reader.getVarInt32();
            if (length == -1) {
                returns.add(((Box)this.elementBox.init()).get());
                continue;
            }
            reader.getBytes(wrapper, length);
            returns.add(((Box)this.elementBox.decode(wrapper)).get());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((List)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = new ByteStream();
        boolean next = false;
        for (Object value : (List)this.value) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.write(((Box)this.elementBox.set(value)).toBytes());
        }
        return builder.toBytes(false);
    }
}

