/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ValueUtils;

public class StringListBox
extends GenericBox<List<String>, StringListBox> {
    @Override
    public final StringListBox set(String[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = List.wrap(value);
        }
        return this;
    }

    @Override
    public StringListBox newInstance() {
        return new StringListBox();
    }

    @Override
    public final StringListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        List<String> returns = new List<String>(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(values2.next());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final StringListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        List<String> returns = new List<String>(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toString());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((List)this.value).size());
        for (String value : (List)this.value) {
            length += container.putString(value, true);
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((List)this.value).size());
        if (((List)this.value).size() > 1) {
            for (String value : (List)this.value) {
                container.putString(value, true);
            }
        }
        return container.toBytes(true);
    }

    @Override
    public final StringListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        List<String> returns = new List<String>(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getString());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((List)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        boolean next = false;
        for (String value : (List)this.value) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(value);
        }
        return builder.toBytes(false);
    }
}

