/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.list;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;

public class VarInt32RangeListBox
extends GenericBox<VarInt32RangeList, VarInt32RangeListBox> {
    @Override
    public VarInt32RangeListBox newInstance() {
        return new VarInt32RangeListBox();
    }

    @Override
    public VarInt32RangeListBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        VarInt32RangeList array = new VarInt32RangeList();
        while (values2.hasNext()) {
            String value = values2.next();
            int index = value.indexOf("~");
            if (index == -1) {
                array.add(Integer.parseInt(value));
                continue;
            }
            if (value.length() == 1) {
                array.addInterval(Integer.MIN_VALUE, Integer.MAX_VALUE);
                continue;
            }
            if (index == 0) {
                array.addInterval(Integer.MIN_VALUE, Integer.parseInt(value.substring(1)));
                continue;
            }
            if (index == value.length() - 1) {
                array.addInterval(Integer.parseInt(value.substring(0, index)), Integer.MAX_VALUE);
                continue;
            }
            array.addInterval(Integer.parseInt(value.substring(0, index)), Integer.parseInt(value.substring(index + 1)));
        }
        values2.clear();
        this.value = array;
        return this;
    }

    @Override
    public VarInt32RangeListBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        VarInt32RangeList array = new VarInt32RangeList();
        while (values2.hasNext()) {
            Bytes value = values2.next();
            int index = value.indexOf((byte)126);
            if (index == -1) {
                array.add(value.toInt());
                continue;
            }
            if (value.length() == 1) {
                array.addInterval(Integer.MIN_VALUE, Integer.MAX_VALUE);
                continue;
            }
            if (index == 0) {
                array.addInterval(Integer.MIN_VALUE, value.subBytes(index + 1).toInt());
                continue;
            }
            if (index == value.length() - 1) {
                array.addInterval(value.subBytes(0, index).toInt(), Integer.MAX_VALUE);
                continue;
            }
            array.addInterval(value.subBytes(0, index).toInt(), value.subBytes(index + 1).toInt());
        }
        values2.clear();
        this.value = array;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        return ((VarInt32RangeList)this.value).encodeTo(container);
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        ((VarInt32RangeList)this.value).encodeTo(container);
        return container.toBytes(true);
    }

    @Override
    public VarInt32RangeListBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        this.value = VarInt32RangeList.decode(container).asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((VarInt32RangeList)this.value).size() == 0L) {
            return Bytes.EMPTY;
        }
        return ((VarInt32RangeList)this.value).toBytes();
    }
}

