/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.map;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;

public class IntMapBox
extends GenericBox<TIntIntMap, IntMapBox> {
    @Override
    public IntMapBox newInstance() {
        return new IntMapBox();
    }

    @Override
    public final IntMapBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(';').init(chars);
        TIntIntHashMap returns = new TIntIntHashMap(ValueUtils.count(chars, ';') + 1);
        while (values2.hasNext()) {
            String value = (String)values2.next();
            if (value.length() <= 0) continue;
            int index = value.indexOf("=");
            if (index == -1) {
                throw new CCFCodingException("Key-Value specification expected but there's no chosen '='");
            }
            returns.put(Integer.parseInt(value.substring(0, index)), Integer.parseInt(value.substring(index + 1)));
        }
        this.value = returns;
        return this;
    }

    @Override
    public final IntMapBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter splitter = new BytesSplitter(59);
        TIntIntHashMap returns = new TIntIntHashMap(chars.valueCount((byte)59) + 1);
        Bytes wrapper = new Bytes();
        while (splitter.hasNext()) {
            Bytes pair = splitter.next();
            if (pair.length() <= 0) continue;
            int index = pair.indexOf((byte)61);
            if (index == -1) {
                throw new CCFCodingException("Key-Value specification expected but there's no chosen '='");
            }
            pair.subBytesTo(0, index, wrapper);
            int key = wrapper.toInt();
            pair.subBytesTo(index + 1, wrapper);
            int value = wrapper.toInt();
            returns.put(key, value);
        }
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((TIntIntMap)this.value).size());
        TIntIterator iterator2 = ((TIntIntMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            int key = iterator2.next();
            length += container.putVarInt32(key);
            length += container.putVarInt32(((TIntIntMap)this.value).get(key));
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((TIntIntMap)this.value).size());
        TIntIterator iterator2 = ((TIntIntMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            int key = iterator2.next();
            container.putVarInt32(key);
            container.putVarInt32(((TIntIntMap)this.value).get(key));
        }
        return container.toBytes(true);
    }

    @Override
    public final IntMapBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        TIntIntHashMap returns = new TIntIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            returns.put(reader.getVarInt32(), reader.getVarInt32());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = TCollections.unmodifiableMap(returns);
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((TIntIntMap)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        boolean next = false;
        TIntIterator iterator2 = ((TIntIntMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            int key = iterator2.next();
            if (next) {
                builder.write(59);
            } else {
                next = true;
            }
            builder.writeChar(key);
            builder.write(61);
            builder.writeChar(((TIntIntMap)this.value).get(key));
        }
        return builder.toBytes(true);
    }
}

