/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.map;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;

public class LongMapBox
extends GenericBox<TLongLongMap, LongMapBox> {
    @Override
    public LongMapBox newInstance() {
        return new LongMapBox();
    }

    @Override
    public final LongMapBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(';').init(chars);
        TLongLongHashMap returns = new TLongLongHashMap(ValueUtils.count(chars, ';') + 1);
        while (values2.hasNext()) {
            String value = (String)values2.next();
            if (value.length() <= 0) continue;
            int index = value.indexOf("=");
            if (index == -1) {
                throw new CCFCodingException("Key-Value specification expected but there's no chosen '='");
            }
            returns.put(Long.parseLong(value.substring(0, index)), Long.parseLong(value.substring(index + 1)));
        }
        this.value = returns;
        return this;
    }

    @Override
    public final LongMapBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter splitter = new BytesSplitter(59);
        TLongLongHashMap returns = new TLongLongHashMap(chars.valueCount((byte)59) + 1);
        Bytes wrapper = new Bytes();
        while (splitter.hasNext()) {
            Bytes pair = splitter.next();
            if (pair.length() <= 0) continue;
            int index = pair.indexOf((byte)61);
            if (index == -1) {
                throw new CCFCodingException("Key-Value specification expected but there's no chosen '='");
            }
            pair.subBytesTo(0, index, wrapper);
            long key = wrapper.toLong();
            pair.subBytesTo(index + 1, wrapper);
            long value = wrapper.toLong();
            returns.put(key, value);
        }
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((TLongLongMap)this.value).size());
        TLongIterator iterator2 = ((TLongLongMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            long key = iterator2.next();
            length += container.putVarInt64(key);
            length += container.putVarInt64(((TLongLongMap)this.value).get(key));
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((TLongLongMap)this.value).size());
        TLongIterator iterator2 = ((TLongLongMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            long key = iterator2.next();
            container.putVarInt64(key);
            container.putVarInt64(((TLongLongMap)this.value).get(key));
        }
        return container.toBytes(true);
    }

    @Override
    public final LongMapBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        TLongLongHashMap returns = new TLongLongHashMap(size);
        for (int i = 0; i < size; ++i) {
            returns.put(reader.getVarInt64(), reader.getVarInt64());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = TCollections.unmodifiableMap(returns);
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((TLongLongMap)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        boolean next = false;
        TLongIterator iterator2 = ((TLongLongMap)this.value).keySet().iterator();
        while (iterator2.hasNext()) {
            long key = iterator2.next();
            if (next) {
                builder.write(59);
            } else {
                next = true;
            }
            builder.writeChar(key);
            builder.write(61);
            builder.writeChar(((TLongLongMap)this.value).get(key));
        }
        return builder.toBytes(true);
    }
}

