/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.map;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBox<K, V>
extends GenericBox<Map<K, V>, MapBox<K, V>> {
    private final Box<K, ?> keyBox;
    private final Box<V, ?> valueBox;

    public MapBox(Box<?, ?> sharedBox) {
        this.keyBox = sharedBox;
        this.valueBox = sharedBox;
    }

    public MapBox(Box<K, ?> keyBox, Box<V, ?> valueBox) {
        this.keyBox = keyBox;
        this.valueBox = valueBox;
    }

    @Override
    public MapBox<K, V> newInstance() {
        if (this.keyBox == this.valueBox) {
            Object sharedBox = this.keyBox.newInstance();
            return new MapBox<K, V>(sharedBox, sharedBox);
        }
        return new MapBox<K, V>(this.keyBox.newInstance(), this.valueBox.newInstance());
    }

    @Override
    public final MapBox<K, V> char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(';').init(chars);
        LinkedHashMap returns = new LinkedHashMap(ValueUtils.count(chars, ';') + 1);
        while (values2.hasNext()) {
            String value = (String)values2.next();
            if (value.length() <= 0) continue;
            int index = value.indexOf("=");
            if (index == -1) {
                returns.put(((Box)this.keyBox.char2Object(value)).get(), null);
                continue;
            }
            if (value.length() == 1) continue;
            if (index == value.length() - 1) {
                returns.put(((Box)this.keyBox.char2Object(value.substring(0, index))).get(), ((Box)this.valueBox.char2Object("")).get());
                continue;
            }
            if (index == 0) {
                returns.put(((Box)this.keyBox.char2Object("")).get(), ((Box)this.valueBox.char2Object(value.substring(1))).get());
                continue;
            }
            returns.put(((Box)this.keyBox.char2Object(value.substring(0, index))).get(), ((Box)this.valueBox.char2Object(value.substring(index + 1))).get());
        }
        this.value = returns;
        return this;
    }

    @Override
    public final MapBox<K, V> char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter splitter = new BytesSplitter(59).init(chars);
        LinkedHashMap returns = new LinkedHashMap(chars.valueCount((byte)59) + 1);
        Bytes wrapper = new Bytes();
        while (splitter.hasNext()) {
            Bytes pair = splitter.next();
            if (pair.length() <= 0) continue;
            int index = pair.indexOf((byte)61);
            if (index == -1) {
                returns.put(((Box)this.keyBox.char2Object(pair, detach)).get(), null);
                continue;
            }
            pair.subBytesTo(0, index, wrapper);
            Object key = ((Box)this.keyBox.char2Object(wrapper, detach)).get();
            pair.subBytesTo(index + 1, wrapper);
            Object value = ((Box)this.valueBox.char2Object(wrapper, detach)).get();
            returns.put(key, value);
        }
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((Map)this.value).size());
        ByteStream temp = new ByteStream();
        Bytes wrapper = new Bytes();
        for (Object key : ((Map)this.value).keySet()) {
            this.keyBox.set(key);
            if (this.keyBox.isNull()) {
                length += container.putVarInt32(-1);
            } else {
                this.keyBox.encodeTo(temp);
                temp.toBytes(wrapper);
                length += container.putVarInt32(wrapper.length());
                length += container.write(wrapper);
                temp.clear();
            }
            this.valueBox.set(((Map)this.value).get(key));
            if (this.valueBox.isNull()) {
                length += container.putVarInt32(-1);
                continue;
            }
            this.valueBox.encodeTo(temp);
            temp.toBytes(wrapper);
            length += container.putVarInt32(wrapper.length());
            length += container.write(wrapper);
            temp.clear();
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = new ByteStream();
        container.putVarInt32(((Map)this.value).size());
        ByteStream temp = new ByteStream();
        Bytes wrapper = new Bytes();
        for (Object key : ((Map)this.value).keySet()) {
            this.keyBox.set(key);
            if (this.keyBox.isNull()) {
                container.putVarInt32(-1);
            } else {
                this.keyBox.encodeTo(temp);
                temp.toBytes(wrapper);
                container.putVarInt32(wrapper.length());
                container.write(wrapper);
                temp.clear();
            }
            this.valueBox.set(((Map)this.value).get(key));
            if (this.valueBox.isNull()) {
                container.putVarInt32(-1);
                continue;
            }
            this.valueBox.encodeTo(temp);
            temp.toBytes(wrapper);
            container.putVarInt32(wrapper.length());
            container.write(wrapper);
            temp.clear();
        }
        return container.toBytes(false);
    }

    @Override
    public final MapBox<K, V> decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        LinkedHashMap returns = new LinkedHashMap(size);
        Bytes wrapper = new Bytes();
        for (int i = 0; i < size; ++i) {
            Object value;
            Object key;
            int length = reader.getVarInt32();
            if (length == -1) {
                key = ((Box)this.keyBox.init()).get();
            } else {
                reader.getBytes(wrapper, length);
                key = ((Box)this.keyBox.decode(wrapper)).get();
            }
            length = reader.getVarInt32();
            if (length == -1) {
                value = ((Box)this.valueBox.init()).get();
            } else {
                reader.getBytes(wrapper, length);
                value = ((Box)this.valueBox.decode(wrapper)).get();
            }
            returns.put(key, value);
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.size() == 0 ? Collections.EMPTY_MAP : Collections.unmodifiableMap(returns);
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((Map)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = new ByteStream();
        boolean next = false;
        for (Object key : ((Map)this.value).keySet()) {
            if (next) {
                builder.write(59);
            } else {
                next = true;
            }
            builder.write(((Box)this.keyBox.set(key)).toBytes());
            this.valueBox.set(((Map)this.value).get(key));
            if (this.valueBox.isNull()) continue;
            builder.write(61);
            builder.write(this.valueBox.toBytes());
        }
        return builder.toBytes(false);
    }
}

