/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.set;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.set.TShortSet;
import gnu.trove.set.hash.TShortHashSet;

public class Int16SetBox
extends GenericBox<TShortSet, Int16SetBox> {
    @Override
    public Int16SetBox set(short value) {
        this.value = new TShortHashSet(1);
        ((TShortSet)this.value).add(value);
        return this;
    }

    @Override
    public Int16SetBox set(short[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new TShortHashSet(value);
        }
        return this;
    }

    @Override
    public Int16SetBox newInstance() {
        return new Int16SetBox();
    }

    @Override
    public Int16SetBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        TShortHashSet returns = new TShortHashSet(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            String value = values2.next();
            if (value.length() <= 0) continue;
            returns.add(Short.parseShort(value));
        }
        this.value = returns;
        return this;
    }

    @Override
    public Int16SetBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        TShortHashSet returns = new TShortHashSet(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            Bytes element = values2.next();
            if (element.length() <= 0) continue;
            returns.add(element.toShort());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((TShortSet)this.value).size());
        TShortIterator iterator2 = ((TShortSet)this.value).iterator();
        while (iterator2.hasNext()) {
            length += container.putShort(iterator2.next());
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((TShortSet)this.value).size());
        TShortIterator iterator2 = ((TShortSet)this.value).iterator();
        while (iterator2.hasNext()) {
            container.putShort(iterator2.next());
        }
        return container.toBytes(true);
    }

    @Override
    public Int16SetBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        TShortHashSet returns = new TShortHashSet(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getShort());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = TCollections.unmodifiableSet(returns);
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((TShortSet)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TShortIterator iterator2 = ((TShortSet)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

