/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.set;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;

public class Int64SetBox
extends GenericBox<TLongSet, Int64SetBox> {
    @Override
    public Int64SetBox set(long value) {
        this.value = new TLongHashSet(1);
        ((TLongSet)this.value).add(value);
        return this;
    }

    @Override
    public Int64SetBox set(long[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new TLongHashSet(value);
        }
        return this;
    }

    @Override
    public Int64SetBox newInstance() {
        return new Int64SetBox();
    }

    @Override
    public Int64SetBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        TLongHashSet returns = new TLongHashSet(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            String value = values2.next();
            if (value.length() <= 0) continue;
            returns.add(Long.parseLong(value));
        }
        this.value = returns;
        return this;
    }

    @Override
    public Int64SetBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        TLongHashSet returns = new TLongHashSet(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            Bytes element = values2.next();
            if (element.length() <= 0) continue;
            returns.add(element.toLong());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((TLongSet)this.value).size());
        TLongIterator iterator2 = ((TLongSet)this.value).iterator();
        while (iterator2.hasNext()) {
            length += container.putVarInt64(iterator2.next());
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((TLongSet)this.value).size());
        TLongIterator iterator2 = ((TLongSet)this.value).iterator();
        while (iterator2.hasNext()) {
            container.putVarInt64(iterator2.next());
        }
        return container.toBytes(true);
    }

    @Override
    public Int64SetBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        TLongHashSet returns = new TLongHashSet(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getVarInt64());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = TCollections.unmodifiableSet(returns);
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((TLongSet)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TLongIterator iterator2 = ((TLongSet)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

