/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.set;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.set.TByteSet;
import gnu.trove.set.hash.TByteHashSet;

public class Int8SetBox
extends GenericBox<TByteSet, Int8SetBox> {
    @Override
    public Int8SetBox set(byte value) {
        this.value = new TByteHashSet(1);
        ((TByteSet)this.value).add(value);
        return this;
    }

    @Override
    public Int8SetBox set(byte[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new TByteHashSet(value);
        }
        return this;
    }

    @Override
    public Int8SetBox newInstance() {
        return new Int8SetBox();
    }

    @Override
    public Int8SetBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        TByteHashSet returns = new TByteHashSet(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(Byte.parseByte(values2.next()));
        }
        this.value = returns;
        return this;
    }

    @Override
    public Int8SetBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        TByteHashSet returns = new TByteHashSet(chars.valueCount((byte)44) + 1);
        while (values2.hasNext()) {
            returns.add(values2.next().toByte());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((TByteSet)this.value).size());
        TByteIterator iterator2 = ((TByteSet)this.value).iterator();
        while (iterator2.hasNext()) {
            length += container.putByte(iterator2.next());
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((TByteSet)this.value).size());
        TByteIterator iterator2 = ((TByteSet)this.value).iterator();
        while (iterator2.hasNext()) {
            container.putByte(iterator2.next());
        }
        return container.toBytes(true);
    }

    @Override
    public Int8SetBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        TByteHashSet returns = new TByteHashSet(size);
        for (int i = 0; i < size; ++i) {
            returns.add(reader.getByte());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = TCollections.unmodifiableSet(returns);
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((TByteSet)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TByteIterator iterator2 = ((TByteSet)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

