/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.set;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collections;
import java.util.Set;

public class SetBox<V>
extends GenericBox<Set<V>, SetBox<V>> {
    private final Box<V, ?> elementBox;

    public SetBox(Box<V, ?> elementBox) {
        this.elementBox = elementBox;
    }

    @Override
    public SetBox<V> newInstance() {
        return new SetBox<V>(this.elementBox.newInstance());
    }

    @Override
    public final SetBox<V> char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        TLinkedHashSet returns = new TLinkedHashSet(ValueUtils.count(chars, ',') + 1);
        while (values2.hasNext()) {
            returns.add(((Box)this.elementBox.char2Object(values2.next())).get());
        }
        values2.clear();
        this.value = returns;
        return this;
    }

    @Override
    public final SetBox<V> char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter splitter = new BytesSplitter(44).init(chars);
        TLinkedHashSet returns = new TLinkedHashSet(chars.valueCount((byte)44) + 1);
        while (splitter.hasNext()) {
            returns.add(((Box)this.elementBox.char2Object(splitter.next(), detach)).get());
        }
        this.value = returns;
        return this;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((Set)this.value).size());
        ByteStream elementEncodedContainer = new ByteStream();
        for (Object value : (Set)this.value) {
            this.elementBox.set(value);
            if (this.elementBox.isNull()) {
                length += container.putVarInt32(-1);
                continue;
            }
            elementEncodedContainer.clear();
            this.elementBox.encodeTo(elementEncodedContainer);
            length += container.putVarInt32(elementEncodedContainer.length());
            length += container.write(elementEncodedContainer.bytes(), elementEncodedContainer.offset(), elementEncodedContainer.length());
        }
        return length;
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = new ByteStream();
        ByteStream elementEncodedContainer = new ByteStream();
        container.putVarInt32(((Set)this.value).size());
        for (Object value : (Set)this.value) {
            this.elementBox.set(value);
            if (this.elementBox.isNull()) {
                container.putVarInt32(-1);
                continue;
            }
            elementEncodedContainer.clear();
            this.elementBox.encodeTo(elementEncodedContainer);
            container.putVarInt32(elementEncodedContainer.length());
            container.write(elementEncodedContainer.bytes(), elementEncodedContainer.offset(), elementEncodedContainer.length());
        }
        elementEncodedContainer.close();
        return container.toBytes(false);
    }

    @Override
    public final SetBox<V> decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        Bytes wrapper = new Bytes();
        int size = reader.getVarInt32();
        TLinkedHashSet returns = new TLinkedHashSet(size);
        for (int i = 0; i < size; ++i) {
            int length = reader.getVarInt32();
            if (length == -1) {
                returns.add(((Box)this.elementBox.init()).get());
                continue;
            }
            reader.getBytes(wrapper, length);
            returns.add(((Box)this.elementBox.decode(wrapper)).get());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = Collections.unmodifiableSet(returns);
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null || ((Set)this.value).size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = new ByteStream();
        boolean next = false;
        for (Object value : (Set)this.value) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.write(((Box)this.elementBox.set(value)).toBytes());
        }
        return builder.toBytes(false);
    }
}

