/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.stringbased;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.ccf.type.decoder.SharedDynamicLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.DynamicLengthEncoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import java.util.function.Function;

public class StringBasedBox<V>
extends GenericBox<V, StringBasedBox<V>> {
    private final Function<String, V> converter;

    public StringBasedBox(Function<String, V> converter) {
        this.converter = converter;
    }

    @Override
    public final StringBasedBox<V> set(String value) {
        return this.char2Object(value);
    }

    @Override
    public StringBasedBox<V> newInstance() {
        return new StringBasedBox<V>(this.converter);
    }

    @Override
    public final StringBasedBox<V> char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = this.converter.apply(chars);
        return this;
    }

    @Override
    public final StringBasedBox<V> char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = this.converter.apply(chars.toString());
        return this;
    }

    @Override
    public final Encoder<StringBasedBox<V>> getEncoder() {
        return new DynamicLengthEncoder<StringBasedBox<V>>();
    }

    public final SharedDynamicLengthDecoder getDecoder() {
        return SharedDynamicLengthDecoder.INSTANCE;
    }

    @Override
    public final int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        String encoded = this.value.toString();
        if (encoded == null || encoded.length() == 0) {
            return 0;
        }
        return container.putString(encoded, false);
    }

    @Override
    public final Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        String encoded = this.value.toString();
        if (encoded == null || encoded.length() == 0) {
            return Bytes.EMPTY;
        }
        return new Bytes(encoded);
    }

    @Override
    public final StringBasedBox<V> decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
        } else {
            this.value = this.converter.apply(container.toString());
        }
        return this;
    }

    @Override
    public final Bytes toBytes() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        String encoded = this.value.toString();
        if (encoded == null || encoded.length() == 0) {
            return Bytes.EMPTY;
        }
        return new Bytes(encoded);
    }
}

