/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.viewer;

import com.formdev.flatlaf.FlatLightLaf;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.viewer.ColumnGroup;
import edu.sysu.pmglab.ccf.viewer.GroupableTableHeader;
import edu.sysu.pmglab.ccf.viewer.ImmutableTable;
import edu.sysu.pmglab.ccf.viewer.ReaderAdaptor;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.utils.ValueUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CCFViewer
extends JFrame {
    private final int eachPageSize;
    private final ReaderAdaptor reader;
    private final LongInterval pageRange;
    private JPanel panel;
    private ImmutableTable dataTable;
    private DefaultTableModel dataTableModel;
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JButton seekButton;
    private JTabbedPane tabbedPanel;
    private long pageIndex = -1L;

    public CCFViewer(ReaderAdaptor reader) throws IOException {
        this(reader, 100, false);
    }

    public CCFViewer(ReaderAdaptor reader, int pagesize, boolean compatible) throws IOException {
        this.$$$setupUI$$$();
        if (reader == null) {
            throw new IOException("Failed to open CCFViewer: invalid file path");
        }
        this.reader = reader;
        this.initComponents(reader, compatible);
        this.eachPageSize = ValueUtils.valueOf(pagesize, 10, 1000000);
        long nums = this.reader.available().end() - this.reader.available().start();
        this.pageRange = new LongInterval(0L, Math.max(1L, nums / (long)this.eachPageSize + (long)(nums % (long)this.eachPageSize == 0L ? 0 : 1)));
        this.nextPageButton.addActionListener(e -> this.loadPage(this.pageIndex + 1L));
        this.previousPageButton.addActionListener(e -> this.loadPage(this.pageIndex - 1L));
        this.seekButton.addActionListener(e -> {
            String inputValue = JOptionPane.showInputDialog("Go to the specified line (" + reader.available().start() + " ~ " + reader.available().end() + "):", (Object)"0");
            if (inputValue == null) {
                return;
            }
            try {
                this.seek(Long.parseLong(inputValue.trim()));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Please enter an integer value", "Unknown format", 0);
            }
        });
        this.seek(reader.tell());
        this.setTitle("CCFViewer: " + this.reader.getTable().getFile().getPath());
        this.pack();
        this.setContentPane(this.panel);
        this.setDefaultCloseOperation(3);
        this.initialCapacity(1050, 550);
        this.setResizable(true);
        this.setVisible(true);
    }

    public void initComponents(ReaderAdaptor reader, boolean compatible) {
        ImmutableTable dataTable;
        Map<String, IndexableSet<String>> headers = reader.getHeader();
        boolean bl = compatible = compatible || headers.size() <= 1;
        if (reader.getTable().numOfFields() > 0 || reader.getTable().numOfRecords() > 0L) {
            this.dataTable = ImmutableTable.of(compatible);
            this.dataTableModel = this.dataTable.getModel();
            TableColumnModel columnModel = this.dataTable.getColumnModel();
            if (compatible) {
                for (String groupName : headers.keySet()) {
                    if (groupName == null) {
                        for (String string : headers.get(null)) {
                            this.dataTableModel.addColumn(string);
                        }
                        continue;
                    }
                    for (String string : headers.get(groupName)) {
                        this.dataTableModel.addColumn(groupName + "@" + string);
                    }
                }
            } else {
                GroupableTableHeader header = (GroupableTableHeader)this.dataTable.getTableHeader();
                for (String string : headers.keySet()) {
                    for (String fieldName : headers.get(string)) {
                        this.dataTableModel.addColumn(fieldName);
                    }
                }
                int index = 0;
                for (String string : headers.keySet()) {
                    ColumnGroup fieldGroup = new ColumnGroup(string);
                    for (String fieldName : headers.get(string)) {
                        fieldGroup.add(columnModel.getColumn(index));
                        ++index;
                    }
                    header.addColumnGroup(fieldGroup);
                }
            }
            this.dataTable.setAutoResizeMode(0);
            this.dataTable.setSelectionMode(2);
            for (int columnIndex = 0; columnIndex < columnModel.getColumnCount(); ++columnIndex) {
                TableColumn column = columnModel.getColumn(columnIndex);
                Component component = this.dataTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.dataTable, column.getHeaderValue(), false, false, -1, columnIndex);
                int n = component.getPreferredSize().width + 20;
                if (columnIndex > 0) {
                    n += 50;
                }
                column.setPreferredWidth(n);
            }
            this.tabbedPanel.add("Records", new JPanel().add(new JScrollPane(this.dataTable)));
        }
        if (reader.getTable().getMeta().size() > 0) {
            dataTable = ImmutableTable.of(true);
            dataTable.setSelectionMode(2);
            dataTable.setAutoResizeMode(0);
            DefaultTableModel dataModel = dataTable.getModel();
            dataModel.addColumn("Key");
            dataModel.addColumn("Type");
            dataModel.addColumn("Value");
            dataTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
            dataTable.getColumnModel().getColumn(2).setPreferredWidth(750);
            for (CCFMetaItem cCFMetaItem : reader.getTable().getMeta()) {
                dataModel.addRow(new Object[]{cCFMetaItem.getKey(), cCFMetaItem.getType(), cCFMetaItem.getValue()});
            }
            this.tabbedPanel.add("Metadata", new JScrollPane(dataTable));
        }
        if (reader.getTable().getOptions().size() > 0) {
            dataTable = ImmutableTable.of(true);
            dataTable.setSelectionMode(2);
            dataTable.setAutoResizeMode(0);
            DefaultTableModel dataModel = dataTable.getModel();
            dataModel.addColumn("Key");
            dataModel.addColumn("Type");
            dataModel.addColumn("Value");
            dataTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
            dataTable.getColumnModel().getColumn(2).setPreferredWidth(750);
            for (CCFMetaItem cCFMetaItem : reader.getTable().getOptions()) {
                dataModel.addRow(new Object[]{cCFMetaItem.getKey(), cCFMetaItem.getType(), cCFMetaItem.getValue()});
            }
            this.tabbedPanel.add("Options", new JScrollPane(dataTable));
        }
        JTextPane textPanel = new JTextPane();
        textPanel.setText(this.reader.toString());
        textPanel.setCaretPosition(0);
        textPanel.setEditable(false);
        this.tabbedPanel.add("Summary Information", new JScrollPane(textPanel));
    }

    void seek(long pointer) {
        if (this.reader.available().start() == this.reader.available().end()) {
            return;
        }
        pointer = ValueUtils.valueOf(pointer, this.reader.available().start(), this.reader.available().end() - 1L);
        long pageIndex = (pointer - this.reader.available().start()) / (long)this.eachPageSize;
        int num = this.loadPage(pageIndex);
        int offset = (int)((pointer - this.reader.available().start()) % (long)this.eachPageSize);
        if (num > 0) {
            this.dataTable.setRowSelectionInterval(offset, offset);
            Rectangle cellRect = this.dataTable.getCellRect(offset, 0, true);
            this.dataTable.scrollRectToVisible(cellRect);
        }
    }

    synchronized int loadPage(long pageIndex) {
        try {
            Object[] row;
            pageIndex = ValueUtils.valueOf(pageIndex, 0L, this.pageRange.end() - 1L);
            if (this.reader == null || this.pageIndex == pageIndex || pageIndex < 0L || pageIndex >= this.pageRange.end()) {
                return 0;
            }
            this.clearAllRow();
            this.reader.seek(this.reader.available().start() + pageIndex * (long)this.eachPageSize);
            int count = 0;
            for (int i = 0; i < this.eachPageSize && (row = this.reader.read()) != null; ++i) {
                ++count;
                this.dataTableModel.addRow(row);
            }
            this.pageIndex = pageIndex;
            return count;
        }
        catch (Error | Exception e) {
            throw new RuntimeException(e);
        }
    }

    void clearAllRow() {
        if (this.dataTable != null) {
            this.dataTable.clearSelection();
            while (this.dataTableModel.getRowCount() != 0) {
                this.dataTableModel.removeRow(0);
            }
        }
    }

    void initialCapacity(int width, int height) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width - width >> 1, dimension.height - height >> 1, width, height);
    }

    static {
        try {
            UIManager.setLookAndFeel(new FlatLightLaf());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.tabbedPanel = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "West");
        this.previousPageButton = jButton3 = new JButton();
        jButton3.setText("\u2190");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(40, -1), new Dimension(40, -1), new Dimension(40, -1)));
        this.nextPageButton = jButton2 = new JButton();
        jButton2.setText("\u2192");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(40, -1), new Dimension(40, -1), new Dimension(40, -1)));
        this.seekButton = jButton = new JButton();
        jButton.setText("Skip To");
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

