/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.viewer;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.filter.CCFFilter;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.viewer.ReaderAdaptor;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CCFViewerReader
implements ReaderAdaptor {
    final CCFReader reader;
    final CCFFilter filter;
    final Map<String, IndexableSet<String>> fields = new LinkedHashMap<String, IndexableSet<String>>();

    public CCFViewerReader(String path) throws IOException {
        this(path, null);
    }

    public CCFViewerReader(LiveFile path) throws IOException {
        this(path, null);
    }

    public CCFViewerReader(CCFTable table) throws IOException {
        this(table, null);
    }

    public CCFViewerReader(IReaderOption<?> table) throws IOException {
        this(table, null);
    }

    public CCFViewerReader(String path, CCFFilter filter) throws IOException {
        this(LiveFile.of(path), filter);
    }

    public CCFViewerReader(LiveFile path, CCFFilter filter) throws IOException {
        this(new CCFTable(path), filter);
    }

    public CCFViewerReader(CCFTable table, CCFFilter filter) throws IOException {
        this((IReaderOption<?>)new ReaderOption(table, new String[0]).addAllFields(), filter);
    }

    public CCFViewerReader(IReaderOption<?> option, CCFFilter filter) throws IOException {
        this.reader = new CCFReader(option);
        this.filter = filter;
        for (final FieldGroupMeta group : this.reader.getAllFields().getAllFieldGroups()) {
            this.fields.put(group.groupName(), (IndexableSet<String>)new LinkedSet<String>(){
                {
                    for (FieldMeta field : group) {
                        this.add(field.simpleName());
                    }
                }
            });
        }
    }

    @Override
    public Map<String, IndexableSet<String>> getHeader() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public Object[] read() throws IOException {
        BoxRecord record = this.reader.getRecord();
        int index = 0;
        if (this.filter == null) {
            if (this.reader.read(record)) {
                Object[] objects = new Object[this.reader.numOfFields()];
                for (String group : this.fields.keySet()) {
                    for (String simple : this.fields.get(group)) {
                        Bytes data = ((Box)record.getBox(group, simple)).toBytes();
                        if (data.length() >= 200) {
                            objects[index++] = "<not loaded>";
                            continue;
                        }
                        objects[index++] = data.toString();
                    }
                }
                return objects;
            }
        } else {
            long pointer = this.filter.filter();
            if (pointer != -1L) {
                this.reader.seek(pointer);
                this.reader.read(record);
                Object[] objects = new Object[this.reader.numOfFields()];
                for (String group : this.fields.keySet()) {
                    for (String simple : this.fields.get(group)) {
                        Bytes data = ((Box)record.getBox(group, simple)).toBytes();
                        if (data.length() >= 200) {
                            objects[index++] = "<not loaded>";
                            continue;
                        }
                        objects[index++] = data.toString();
                    }
                }
                return objects;
            }
        }
        return null;
    }

    @Override
    public long numOfRecords() {
        return this.reader.numOfRecords();
    }

    @Override
    public void seek(long pointer) throws IOException {
        this.reader.seek(pointer);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    @Override
    public LongInterval available() {
        return this.reader.available();
    }

    @Override
    public long tell() {
        return this.reader.tell();
    }

    @Override
    public CCFTable getTable() {
        return this.reader.getTable();
    }

    @Override
    public String toString() {
        return this.reader.getTable().toString();
    }
}

