/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.viewer;

import edu.sysu.pmglab.ccf.viewer.ColumnGroup;
import edu.sysu.pmglab.ccf.viewer.GroupableTableHeaderUI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeader
extends JTableHeader {
    protected Vector<ColumnGroup> columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    @Override
    public void updateUI() {
        this.setUI(new GroupableTableHeaderUI());
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public Enumeration<?> getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration<ColumnGroup> e = this.columnGroups.elements();
        while (e.hasMoreElements()) {
            ColumnGroup cGroup = e.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<ColumnGroup> e = this.columnGroups.elements();
        while (e.hasMoreElements()) {
            ColumnGroup cGroup = e.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

