/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.converter.DynamicParameter;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.validator.EmptyValidator;
import edu.sysu.pmglab.commandParser.validator.IValidator;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class CommandItem {
    private final Annotation source;
    private final Consumer<Object> invoker;
    private final String[] names;
    private final IntInterval arity;
    private final IConverter<?> converter;
    private final IValidator validator;
    private final boolean required;
    private final boolean greedy;
    private final boolean repeated;
    private final OptionUsage usage;
    private final Object defaultValue;
    private final String[] defaultValueAsString;
    private final Function<String[], String[]> preprocessor;

    CommandItem(EntryOption option, Field field, Object instance) {
        this.source = option;
        this.names = CommandItem.parseNames(option.value());
        this.arity = new IntInterval(0, Integer.MAX_VALUE);
        this.converter = (names, values2) -> values2;
        this.invoker = option.bind() ? o -> ReflectionUtils.setValue(instance, field, o) : null;
        this.preprocessor = option.retain() ? params -> {
            String[] wrapper = new String[((String[])params).length + 1];
            wrapper[0] = this.names[0];
            System.arraycopy(params, 0, wrapper, 1, ((String[])params).length);
            return wrapper;
        } : args -> args;
        this.validator = EmptyValidator.INSTANCE;
        this.required = false;
        this.greedy = true;
        this.repeated = false;
        this.usage = field.getDeclaredAnnotation(OptionUsage.class);
        this.defaultValue = ReflectionUtils.getValue(instance, field);
        this.defaultValueAsString = EmptyArray.STRING;
    }

    CommandItem(Option option, Field field, Object instance) {
        IConverter valueConverter;
        Object defaults;
        this.source = option;
        this.names = CommandItem.parseNames(option.names());
        this.invoker = option.bind() ? o -> ReflectionUtils.setValue(instance, field, o) : null;
        this.required = option.required();
        this.greedy = false;
        this.repeated = option.repeated();
        this.usage = field.getDeclaredAnnotation(OptionUsage.class);
        if (option.type() == FieldType.NULL && option.container() != Container.NONE) {
            throw new CommandParserException("Confusing value type: the parameter '" + this.names[0] + "' is of NULL type, but it is instructed to return a container type");
        }
        this.defaultValue = option.type() == FieldType.NULL ? ((defaults = ReflectionUtils.getValue(instance, field)) instanceof Boolean || option.bind() ? defaults : Boolean.valueOf(false)) : ReflectionUtils.getValue(instance, field);
        if (!this.repeated && option.defaultTo().length > 1) {
            throw new CommandParserException("Confusing default value: the parameter '" + this.names[0] + "' is not repeated, yet multiple values (in @Option) were provided");
        }
        this.defaultValueAsString = option.defaultTo();
        if (option.available().value().length > 0 || option.available().upper()) {
            Set<String> values3 = option.available().value().length == 0 ? null : List.wrap(option.available().value()).toSet();
            this.preprocessor = params -> {
                for (int i = 0; i < ((String[])params).length; ++i) {
                    String string = params[i] = option.available().upper() ? params[i].toUpperCase() : params[i];
                    if (values3 == null || values3.contains(params[i])) continue;
                    throw new ParameterException("Invalid parameter: \"" + this.name() + "\" should be one of the following: " + List.wrap(values3).toString(", ") + " (" + params[i] + " given)");
                }
                return params;
            };
        } else {
            this.preprocessor = params -> params;
        }
        if (option.container() == Container.NONE) {
            this.arity = option.type() == FieldType.NULL ? new IntInterval(0, 0) : new IntInterval(1, 1);
            this.converter = IConverter.instanceOf(option.type());
            this.validator = option.validator() == EmptyValidator.class ? EmptyValidator.INSTANCE : ReflectionUtils.getInstance(option.validator(), null, null);
        } else if (option.container() == Container.SET) {
            this.arity = new IntInterval(0, Integer.MAX_VALUE);
            valueConverter = IConverter.instanceOf(option.type());
            this.converter = (name, values2) -> {
                LinkedSet sets = new LinkedSet(values2.length);
                for (String value : values2) {
                    ((AbstractCollection)sets).add(valueConverter.convert(name, value));
                }
                return sets.asUnmodifiable();
            };
            IValidator<?> valueValidator = ReflectionUtils.getInstance(option.validator(), null, null);
            this.validator = option.validator() == EmptyValidator.class ? EmptyValidator.INSTANCE : (name, values2) -> {
                for (Object value : values2) {
                    valueValidator.validate(name, value);
                }
            };
        } else if (option.container() == Container.LIST) {
            this.arity = new IntInterval(0, Integer.MAX_VALUE);
            valueConverter = IConverter.instanceOf(option.type());
            this.converter = (name, values2) -> {
                List lists = new List(values2.length);
                for (String value : values2) {
                    lists.add(valueConverter.convert(name, value));
                }
                return lists.asUnmodifiable();
            };
            final IValidator<?> valueValidator = ReflectionUtils.getInstance(option.validator(), null, null);
            this.validator = option.validator() == EmptyValidator.class ? EmptyValidator.INSTANCE : new IValidator<List<?>>(){

                @Override
                public void validate(String name, List<?> values2) throws ParameterException {
                    for (Object value : values2) {
                        valueValidator.validate(name, value);
                    }
                }
            };
        } else {
            throw new CommandParserException("Unknown container type: " + (Object)((Object)option.container()));
        }
    }

    CommandItem(final DynamicOption option, Field field, Object instance) {
        this.source = option;
        this.names = CommandItem.parseNames(option.names());
        this.invoker = option.bind() ? o -> ReflectionUtils.setValue(instance, field, o) : null;
        this.required = option.required();
        this.greedy = false;
        this.repeated = option.repeated();
        this.usage = field.getDeclaredAnnotation(OptionUsage.class);
        this.defaultValue = ReflectionUtils.getValue(instance, field);
        if (!this.repeated && option.defaultTo().length > 1) {
            throw new CommandParserException("Confusing default value: the parameter '" + this.names[0] + "' is not repeated, yet multiple values (in @Option) were provided");
        }
        this.defaultValueAsString = option.defaultTo();
        this.preprocessor = params -> params;
        this.validator = option.validator() == EmptyValidator.class ? EmptyValidator.INSTANCE : ReflectionUtils.getInstance(option.validator(), null, null);
        final DynamicParameter parameter = new DynamicParameter(option.arbitrary(), option.args());
        this.arity = parameter.getArity();
        this.converter = new IConverter<Object>(){
            final IDynamicConverter dynamicConverter;
            {
                this.dynamicConverter = ReflectionUtils.getInstance(option.converter(), null, null);
            }

            @Override
            public Object convert(String name, String ... values2) {
                Map<String, String> params = parameter.binding(name, values2);
                return this.dynamicConverter.convert(name, params);
            }
        };
    }

    CommandItem(CustomOption option, Field field, Object instance) {
        this.source = option;
        this.names = CommandItem.parseNames(option.names());
        this.invoker = option.bind() ? o -> ReflectionUtils.setValue(instance, field, o) : null;
        this.arity = CommandItem.parseArity(option.arity());
        this.required = option.required();
        this.greedy = option.greedy();
        this.repeated = option.repeated();
        this.usage = field.getDeclaredAnnotation(OptionUsage.class);
        this.defaultValue = ReflectionUtils.getValue(instance, field);
        if (!this.repeated && option.defaultTo().length > 1) {
            throw new CommandParserException("Confusing default value: the parameter '" + this.names[0] + "' is not repeated, yet multiple values (in @Option) were provided");
        }
        this.defaultValueAsString = option.defaultTo();
        this.preprocessor = params -> params;
        this.validator = option.validator() == EmptyValidator.class ? EmptyValidator.INSTANCE : ReflectionUtils.getInstance(option.validator(), null, null);
        this.converter = ReflectionUtils.getInstance(option.converter(), null, null);
    }

    static List<CommandItem> load(Field field, Object instance) {
        if (instance instanceof Class) {
            throw new CommandParserException("Unable to load field " + field + " from instance " + instance);
        }
        int count = 0;
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation.annotationType() == Option.class) {
                if (count == 0) {
                    ++count;
                } else {
                    throw new CommandParserException("'" + field + "' has multiple @Option annotations");
                }
            }
            if (annotation.annotationType() == CustomOption.class) {
                if (count == 0) {
                    ++count;
                } else {
                    throw new CommandParserException("'" + field + "' has multiple @Option annotations");
                }
            }
            if (annotation.annotationType() == EntryOption.class) {
                if (count == 0) {
                    ++count;
                } else {
                    throw new CommandParserException("'" + field + "' has multiple @Option annotations");
                }
            }
            if (annotation.annotationType() == DynamicOption.class) {
                if (count == 0) {
                    ++count;
                } else {
                    throw new CommandParserException("'" + field + "' has multiple @Option annotations");
                }
            }
            if (annotation.annotationType() != OptionBundle.class) continue;
            if (count == 0) {
                ++count;
            } else {
                throw new CommandParserException("'" + field + "' has multiple @Option annotations");
            }
            if (field.getAnnotation(OptionUsage.class) == null) continue;
            throw new CommandParserException("The @OptionBundle does not allow the use of the @OptionUsage annotation");
        }
        if (count == 0) {
            return new List<CommandItem>(0);
        }
        if (field.getAnnotation(OptionBundle.class) != null) {
            OptionBundle group = field.getAnnotation(OptionBundle.class);
            if ((instance = ReflectionUtils.getValue(instance, field)) == null) {
                throw new CommandParserException("'" + field.getType().getName() + " " + field.getName() + "' is not initialized");
            }
            List<Field> fields = ReflectionUtils.getFields(instance.getClass());
            List<CommandItem> items = new List<CommandItem>();
            Set<String> filters = List.wrap(group.value()).toSet();
            for (Field subField : fields) {
                if (filters.size() == 0) {
                    items.addAll(CommandItem.load(subField, instance));
                    continue;
                }
                block2: for (CommandItem item : CommandItem.load(subField, instance)) {
                    for (String name : item.names()) {
                        if (!filters.contains(name)) continue;
                        items.add(item);
                        continue block2;
                    }
                }
            }
            return items;
        }
        if (field.getAnnotation(Option.class) != null) {
            return List.singleton(new CommandItem(field.getAnnotation(Option.class), field, instance));
        }
        if (field.getAnnotation(DynamicOption.class) != null) {
            return List.singleton(new CommandItem(field.getAnnotation(DynamicOption.class), field, instance));
        }
        if (field.getAnnotation(CustomOption.class) != null) {
            return List.singleton(new CommandItem(field.getAnnotation(CustomOption.class), field, instance));
        }
        if (field.getAnnotation(EntryOption.class) != null) {
            return List.singleton(new CommandItem(field.getAnnotation(EntryOption.class), field, instance));
        }
        throw new CommandParserException();
    }

    private static String[] parseNames(String[] names) {
        if (names == null || names.length == 0) {
            throw new CommandParserException("Invalid name: requires at least one option name");
        }
        for (String name : names) {
            if (name.length() != 0) continue;
            throw new CommandParserException("Invalid name: the option name cannot be empty");
        }
        List<String> cleanNames = List.wrap(names);
        cleanNames.dropDuplicates();
        return cleanNames.toArray((T1[])EmptyArray.STRING);
    }

    private static IntInterval parseArity(int[] arity) {
        if (arity.length == 1) {
            int length = arity[0];
            if (length < -1) {
                throw new CommandParserException("Invalid arity: arity must be -1 (means variable length) or a non-negative integer");
            }
            if (length == -1) {
                return new IntInterval(0, Integer.MAX_VALUE);
            }
            return new IntInterval(length, length);
        }
        if (arity.length == 2) {
            int minValue;
            int n = minValue = arity[0] == -1 ? 0 : arity[0];
            if (minValue < 0) {
                throw new CommandParserException("Invalid arity: arity must be -1 (means variable length) or a non-negative integer");
            }
            if (arity[1] == -1) {
                return new IntInterval(minValue, Integer.MAX_VALUE);
            }
            if (arity[1] < 0) {
                throw new CommandParserException("Invalid arity: arity must be -1 (means variable length) or a non-negative integer");
            }
            if (minValue > arity[1]) {
                throw new CommandParserException("Invalid arity: minValue > maxValue");
            }
            return new IntInterval(minValue, arity[1]);
        }
        throw new CommandParserException("Invalid arity: arity = <int> or arity = {minArity, maxArity} for \"arity\", where -1 means no restriction on the number of arguments");
    }

    public String name() {
        return this.names[0];
    }

    public List<String> names() {
        return List.wrap(this.names).asUnmodifiable();
    }

    public <T extends Annotation> T source() {
        return (T)this.source;
    }

    public <T extends Annotation> boolean isInstance(Class<T> tClass) {
        return this.source.annotationType().isAssignableFrom(tClass);
    }

    public IntInterval arity() {
        return this.arity;
    }

    public <T> T defaultValue() {
        return (T)this.defaultValue;
    }

    public String[] defaultValueAsString() {
        return this.defaultValueAsString;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    CommandItem invoke(Object value) {
        if (this.invoker != null) {
            this.invoker.accept(value);
        }
        return this;
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    public IConverter<?> getConverter() {
        return this.converter;
    }

    public OptionUsage usage() {
        return this.usage;
    }

    public <T> CommandOption<T> parse(String ... args) {
        boolean plural;
        if (args == null || Arrays.stream(args).anyMatch(Objects::isNull)) {
            throw new ParameterException("Invalid parameter: null");
        }
        if (this.arity.contains((args = this.preprocessor.apply(args)).length, true)) {
            if (this.converter == null) {
                boolean value;
                boolean bl = value = this.defaultValue == null || (Boolean)this.defaultValue == false;
                if (this.validator != null) {
                    this.validator.validate(this.names[0], value);
                }
                List<String[]> source2 = List.singleton(args);
                return new CommandOption<Boolean>(this, true, value, args.length, source2);
            }
            Object value = this.converter.convert(this.names[0], args);
            if (this.validator != null) {
                this.validator.validate(this.names[0], value);
            }
            List<String[]> source3 = List.singleton(args);
            return new CommandOption(this, true, value, args.length, source3);
        }
        boolean bl = plural = this.arity.start() > 1;
        if (this.arity.end() == Integer.MAX_VALUE) {
            throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes at least " + this.arity.start() + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
        }
        if (this.arity.start() == this.arity.end()) {
            throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes " + this.arity.start() + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
        }
        throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes " + this.arity + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
    }

    public <T> CommandOption<List<T>> parse(List<String[]> multiArgs) {
        if (multiArgs == null) {
            throw new ParameterException("Invalid parameter: null");
        }
        for (int i = 0; i < multiArgs.size(); ++i) {
            multiArgs.set(i, this.preprocessor.apply(multiArgs.get(i)));
        }
        List values2 = new List();
        for (String[] args : multiArgs) {
            boolean plural;
            if (this.arity.contains(args.length, true)) {
                Object value = this.converter.convert(this.names[0], args);
                if (this.validator != null) {
                    this.validator.validate(this.names[0], value);
                }
                values2.add(value);
                continue;
            }
            boolean bl = plural = this.arity.start() > 1;
            if (this.arity.end() == Integer.MAX_VALUE) {
                throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes at least " + this.arity.start() + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
            }
            if (this.arity.start() == this.arity.end()) {
                throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes " + this.arity.start() + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
            }
            throw new ParameterException("Invalid parameter: \"" + this.names[0] + "\" takes " + this.arity + " positional argument" + (plural ? "s" : "") + " (" + args.length + " given)");
        }
        return new CommandOption(this, true, values2.asUnmodifiable(), multiArgs.size(), multiArgs);
    }

    public int hashCode() {
        return this.names[0].hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return "CommandItem{names=" + Arrays.toString(this.names) + ", arity=" + this.arity + ", converter=" + this.converter + ", validator=" + this.validator + ", required=" + this.required + ", greedy=" + this.greedy + ", repeated=" + this.repeated + (this.defaultValue == null ? "" : ", defaultValue=" + this.defaultValue) + '}';
    }
}

