/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser;

import edu.sysu.pmglab.commandParser.CommandItem;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandParser;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class CommandOptions
implements Iterable<CommandOption<?>> {
    private final LinkedHashMap<CommandItem, CommandOption<?>> values = new LinkedHashMap();
    private final CommandParser parser;
    private final boolean help;

    CommandOptions(CommandParser parser, Map<CommandItem, List<String[]>> options) {
        if (parser == null || options == null) {
            throw new CommandParserException("");
        }
        this.parser = parser;
        CommandItem helpItem = this.parser.get("--help");
        this.help = options.containsKey(helpItem);
        if (this.help) {
            String[] passedIn = options.get(helpItem).get(0);
            this.values.put(helpItem, helpItem.parse(passedIn));
            for (CommandItem commandItem : this.parser) {
                if (this.values.containsKey(commandItem)) continue;
                this.values.put(commandItem, new CommandOption(commandItem, false, commandItem.defaultValue(), -1, null));
            }
        } else {
            LinkedHashSet<String> errors = new LinkedHashSet<String>(0);
            for (CommandItem commandItem : options.keySet()) {
                List<String[]> args = options.get(commandItem);
                Assert.that(args != null);
                if (commandItem.isRepeated()) {
                    this.values.put(commandItem, commandItem.parse(args));
                    continue;
                }
                Assert.that(args.size() == 1);
                this.values.put(commandItem, commandItem.parse(args.get(0)));
            }
            for (CommandItem commandItem : this.parser) {
                if (commandItem.isRequired() && !this.values.containsKey(commandItem)) {
                    errors.add("\"" + commandItem.name() + "\"");
                }
                if (this.values.containsKey(commandItem)) continue;
                this.values.put(commandItem, new CommandOption(commandItem, false, commandItem.defaultValue(), -1, null));
            }
            if (errors.size() > 0) {
                throw new ParameterException("Missing required option: " + List.wrap(errors).toString(", "));
            }
        }
    }

    public boolean isHelp() {
        return this.help;
    }

    public CommandParser getParser() {
        return this.parser;
    }

    public boolean contains(String commandName) {
        return this.parser.contains(commandName);
    }

    public boolean passed(String commandName) {
        CommandItem item = this.parser.get(commandName);
        if (item == null) {
            throw new CommandParserException("Invalid option: \"" + commandName + "\" not defined");
        }
        return this.values.get((Object)item).passed;
    }

    public <T> CommandOption<T> get(String commandName) {
        CommandItem item = this.parser.get(commandName);
        if (item == null) {
            throw new CommandParserException("Invalid option: \"" + commandName + "\" not defined");
        }
        return this.values.get(item);
    }

    public <T> T value(String commandName) {
        CommandItem item = this.parser.get(commandName);
        if (item == null) {
            throw new CommandParserException("Invalid option: \"" + commandName + "\" not defined");
        }
        return (T)this.values.get((Object)item).value;
    }

    public <T> T valueOrDefault(String commandName, T defaultValue) {
        CommandOption<T> item = this.get(commandName);
        if (item.passed) {
            return (T)item.value;
        }
        return defaultValue;
    }

    @Override
    public Iterator<CommandOption<?>> iterator() {
        return this.values.values().iterator();
    }

    <T> CommandOptions invoke() {
        if (!this.help) {
            for (CommandItem item : this.values.keySet()) {
                if (!this.passed(item.name())) continue;
                if (item.getConverter() == null) {
                    if (item.defaultValue() == null) {
                        item.invoke(true);
                        continue;
                    }
                    item.invoke((Boolean)item.defaultValue() == false);
                    continue;
                }
                item.invoke(this.get((String)item.name()).value);
            }
        }
        return this;
    }

    public String toString() {
        return this.parser.summary(this);
    }

    public String usage() {
        return this.parser.usage();
    }
}

