/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.commandParser.CommandItem;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.Helper;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Chain;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.rule.ChainRule;
import edu.sysu.pmglab.commandParser.rule.CountRule;
import edu.sysu.pmglab.commandParser.rule.IRule;
import edu.sysu.pmglab.commandParser.usage.parser.IParserUsage;
import edu.sysu.pmglab.commandParser.usage.parser.unix.DefaultUnixStyleParserUsage;
import edu.sysu.pmglab.commandParser.usage.parser.unix.UnixStyleParserUsage;
import edu.sysu.pmglab.commandParser.usage.summary.DefaultParsingSummary;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.NamedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ReflectionUtils;
import gnu.trove.set.hash.THashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class CommandParser
implements Iterable<CommandItem> {
    public static final String VERSION = "3.0";
    private static final IFilter<Field> filter = field -> field.getAnnotation(Option.class) != null || field.getAnnotation(OptionBundle.class) != null || field.getAnnotation(CustomOption.class) != null || field.getAnnotation(DynamicOption.class) != null || field.getAnnotation(EntryOption.class) != null;
    private final IParserUsage parserUsage;
    private final IParsingSummary summaryUsage;
    private final NamedSet<Object> items = new NamedSet();
    private final List<IRule> rules = new List();
    private final Indirect indirect;

    CommandParser(ICommandProgram program) {
        Assert.that(program != null);
        this.addCommandItem(ReflectionUtils.getField(Helper.class, "help"), new Helper());
        Parser parser = ReflectionUtils.getAnnotation(Parser.class, program);
        for (Field field2 : ReflectionUtils.getFields(program.getClass(), filter)) {
            this.addCommandItem(field2, program);
        }
        if (parser == null) {
            this.parserUsage = new DefaultUnixStyleParserUsage();
            this.summaryUsage = new DefaultParsingSummary();
            this.indirect = null;
        } else {
            this.indirect = parser.indirect().enable() ? parser.indirect() : null;
            for (Class<?> delegation : parser.delegation()) {
                Object instance;
                List<Field> fields = ReflectionUtils.getFields(delegation, filter);
                if (fields.size() <= 0) continue;
                if (delegation.isEnum()) {
                    instance = ReflectionUtils.getInstance(delegation, null, null);
                    for (Field field3 : fields) {
                        this.addCommandItem(field3, instance);
                    }
                    continue;
                }
                if (fields.any(field -> !Modifier.isStatic(field.getModifiers()))) {
                    instance = ReflectionUtils.getInstance(delegation, null, null);
                    for (Field field3 : fields) {
                        this.addCommandItem(field3, instance);
                    }
                    continue;
                }
                for (Field field4 : fields) {
                    this.addCommandItem(field4, null);
                }
            }
            this.addRules(parser.rule());
            this.parserUsage = parser.usage_style() == DefaultUnixStyleParserUsage.class || parser.usage_style() == UnixStyleParserUsage.class ? new DefaultUnixStyleParserUsage() : ReflectionUtils.getInstance(parser.usage_style(), null, null);
            if (parser.usage().length() != 0) {
                this.parserUsage.addItem("Usage", parser.usage());
            }
            for (UsageItem item : parser.usage_item()) {
                this.parserUsage.addItem(item.key(), List.wrap(item.value()).toString("\n"));
            }
            this.summaryUsage = parser.summary_style() == DefaultParsingSummary.class || parser.summary_style() == IParsingSummary.class ? new DefaultParsingSummary() : ReflectionUtils.getInstance(parser.summary_style(), null, null);
            for (Class<? extends IObjectObjectFilter<CommandOptions, CommandOption<?>>> filterClass : parser.summary_filter()) {
                this.summaryUsage.addFilter((IObjectObjectFilter)ReflectionUtils.getInstance(filterClass, null, null));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] readParamsFromFile(CommandItem item, Indirect indirect, String fileName) {
        try (ReaderStream reader = LiveFile.of(fileName).openAsText();){
            ByteStream line = new ByteStream();
            Bytes bytes = new Bytes();
            List<String> tokens = new List<String>();
            block11: while (true) {
                int n;
                String[] stringArray;
                if (reader.readline(line) != -1) {
                    line.toBytes(bytes);
                    line.clear();
                    if (indirect.trim()) {
                        bytes = bytes.trim();
                    }
                    if (bytes.length() == 0 && indirect.ignoreBlankLines()) continue;
                    stringArray = indirect.comment();
                    n = stringArray.length;
                } else {
                    stringArray = tokens.toArray((T1[])EmptyArray.STRING);
                    return stringArray;
                }
                for (int i = 0; i < n; ++i) {
                    String comment = stringArray[i];
                    if (bytes.startsWith(comment.getBytes(StandardCharsets.UTF_8))) continue block11;
                }
                tokens.add(bytes.toString());
            }
        }
        catch (Error | Exception e) {
            throw new ParameterException("Invalid option: \"" + item.name() + "\" encountered an exception when reading the parameter value from argument file " + fileName, e);
        }
    }

    private static IRule convertRule(final Counter rule, final String description) {
        IRule[] rules = new IRule[rule.item().length];
        int index = 0;
        for (String name : rule.item()) {
            rules[index++] = options -> options.passed(name);
        }
        if (rule.rule() == Counter.Type.EQUAL || rule.rule() == null) {
            return new CountRule(count -> count == rule.count(), rules){

                public String toString() {
                    if (description.length() == 0) {
                        return "{" + List.wrap(rule.item()).toString(", ") + "} require " + rule.count();
                    }
                    return description;
                }
            };
        }
        if (rule.rule() == Counter.Type.AT_MOST) {
            return new CountRule(count -> count <= rule.count(), rules){

                public String toString() {
                    if (description.length() == 0) {
                        return "At most " + rule.count() + " of {" + List.wrap(rule.item()).toString(", ") + "} are required";
                    }
                    return description;
                }
            };
        }
        return new CountRule(count -> count >= rule.count(), rules){

            public String toString() {
                if (description.length() == 0) {
                    return "At least " + rule.count() + " of {" + List.wrap(rule.item()).toString(", ") + "} are required";
                }
                return description;
            }
        };
    }

    private static IRule convertRule(final Class<? extends IRule> rule, final String description) {
        try {
            return new IRule(){
                final IRule basicRule;
                {
                    this.basicRule = (IRule)ReflectionUtils.getInstance(rule, null, null);
                }

                @Override
                public boolean filter(CommandOptions options) {
                    return this.basicRule.filter(options);
                }

                public String toString() {
                    if (description == null || description.length() == 0) {
                        return this.basicRule.toString();
                    }
                    return description;
                }
            };
        }
        catch (Error | Exception e) {
            throw new CommandParserException(e);
        }
    }

    private static IRule convertRule(Chain chain, final String description) {
        IRule[] rules = new IRule[chain.item().length];
        int index = 0;
        for (Counter rule : chain.item()) {
            rules[index++] = CommandParser.convertRule(rule, description);
        }
        if (rules.length == 1) {
            return rules[0];
        }
        return new ChainRule(rules){

            public String toString() {
                return description;
            }
        };
    }

    private void addCommandItem(Field field, Object object) {
        List<CommandItem> items = CommandItem.load(field, object);
        for (CommandItem item : items) {
            for (String name : item.names()) {
                if (!this.items.contains(name)) continue;
                throw new CommandParserException("Command item named \"" + name + "\" has already been registered in this instance of CommandParser:\n" + this.get(name));
            }
            this.items.adds(new CommandOption(item, false, item.defaultValue(), -1, null), item.names());
        }
    }

    private CommandParser addRules(Rule rules) {
        if (rules == null) {
            return this;
        }
        for (Counter counter : rules.counter()) {
            if (counter.item().length <= 0) continue;
            THashSet<String> names = new THashSet<String>();
            for (String item : counter.item()) {
                CommandItem commandItem = this.get(item);
                if (commandItem == null) {
                    throw new CommandParserException("Command item not found: " + item);
                }
                if (names.contains(commandItem.name())) {
                    throw new CommandParserException("Duplicated command item: " + item);
                }
                names.add(commandItem.name());
            }
            this.rules.add(CommandParser.convertRule(counter, counter.description()));
        }
        for (Annotation annotation : rules.function()) {
            this.rules.add(CommandParser.convertRule(annotation.item(), annotation.description()));
        }
        for (Annotation annotation : rules.chain()) {
            if (annotation.item().length > 1) {
                this.rules.add(CommandParser.convertRule((Chain)annotation, annotation.description()));
                continue;
            }
            if (annotation.item().length != 1) continue;
            this.rules.add(CommandParser.convertRule(annotation.item()[0], annotation.description()));
        }
        return this;
    }

    public boolean contains(String commandName) {
        return this.items.contains(commandName);
    }

    public CommandItem get(String commandName) {
        if (this.items.contains(commandName)) {
            return ((CommandOption)this.items.valueOf((Object)commandName)).commandItem;
        }
        return null;
    }

    public int numOfItems() {
        return this.items.size();
    }

    @Override
    public Iterator<CommandItem> iterator() {
        final Iterator options = this.items.iterator();
        return new Iterator<CommandItem>(){

            @Override
            public boolean hasNext() {
                return options.hasNext();
            }

            @Override
            public CommandItem next() {
                return ((CommandOption)options.next()).commandItem;
            }
        };
    }

    CommandOptions parse(String ... args) {
        List<String> params = new List<String>(args);
        LinkedHashMap<CommandItem, List<String[]>> matchers = new LinkedHashMap<CommandItem, List<String[]>>();
        if (params.size() == 0) {
            List<String[]> wrapper = List.singleton(EmptyArray.STRING);
            matchers.put(this.get("--help"), wrapper);
        }
        block0: while (params.size() > 0) {
            List<String[]> wrapper;
            String param = params.popFirst();
            CommandItem commandItem = this.get(param);
            if (commandItem == null) {
                throw new ParameterException("Invalid option: \"" + param + "\" not defined");
            }
            if (matchers.containsKey(commandItem) && !commandItem.isRepeated()) {
                throw new ParameterException("Invalid option: \"" + param + "\" repeated");
            }
            if (matchers.containsKey(commandItem)) {
                wrapper = (List<String[]>)matchers.get(commandItem);
            } else {
                wrapper = new List<String[]>(1);
                matchers.put(commandItem, wrapper);
            }
            if (this.indirect != null) {
                if (params.size() == 0) {
                    wrapper.add(new String[0]);
                    continue;
                }
                if (params.get(0).startsWith(this.indirect.anchor())) {
                    wrapper.add(CommandParser.readParamsFromFile(commandItem, this.indirect, params.popFirst().substring(1)));
                    continue;
                }
            }
            if (commandItem.isGreedy()) {
                if (commandItem.arity().end() == Integer.MAX_VALUE) {
                    wrapper.add(params.popFirst(params.size(), true).toArray((T1[])EmptyArray.STRING));
                    continue;
                }
                if (commandItem.arity().end() == 0) {
                    wrapper.add(new String[0]);
                    continue;
                }
                wrapper.add(params.popFirst(Math.min(params.size(), commandItem.arity().end()), true).toArray((T1[])EmptyArray.STRING));
                continue;
            }
            if (commandItem.arity().start() == 0 && commandItem.arity().end() == 0) {
                wrapper.add(new String[0]);
                continue;
            }
            if (commandItem.arity().start() == commandItem.arity().end()) {
                wrapper.add(params.popFirst(Math.min(params.size(), commandItem.arity().start()), true).toArray((T1[])EmptyArray.STRING));
                continue;
            }
            if (params.size() <= commandItem.arity().start()) {
                wrapper.add(params.popFirst(params.size(), true).toArray((T1[])EmptyArray.STRING));
                continue;
            }
            int maxEnd = Math.min(commandItem.arity().end(), params.size());
            for (int i = commandItem.arity().start(); i < maxEnd; ++i) {
                if (this.get(params.get(i)) == null) continue;
                wrapper.add(params.popFirst(i, true).toArray((T1[])EmptyArray.STRING));
                continue block0;
            }
            wrapper.add(params.popFirst(maxEnd, true).toArray((T1[])EmptyArray.STRING));
        }
        CommandOptions options = new CommandOptions(this, matchers);
        if (!options.isHelp()) {
            for (IRule rule : this.rules) {
                rule.validate(options);
            }
        }
        return options.invoke();
    }

    String usage() {
        return this.parserUsage.format(this);
    }

    String summary(CommandOptions options) {
        return this.summaryUsage.format(options);
    }
}

