/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.set.hash.THashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DynamicParameter {
    final Set<String> keywords = new THashSet<String>();
    final Param[] argLists;
    final IntInterval arity;
    final boolean arbitrary;

    public DynamicParameter(boolean arbitrary, String ... argLists) {
        this.argLists = new Param[argLists.length];
        int counter = 0;
        for (int i = 0; i < argLists.length; ++i) {
            String arg = argLists[i];
            this.argLists[i] = new Param(arg);
            if (!this.keywords.add(this.argLists[i].keyword)) {
                throw new CommandParserException("duplicated argument '" + this.argLists[i].keyword + "' in function table");
            }
            if (i > 0 && this.argLists[i - 1].defaultValue != null && this.argLists[i].defaultValue == null) {
                throw new CommandParserException("non-default argument follows default argument: " + arg);
            }
            if (this.argLists[i].defaultValue != null) continue;
            ++counter;
        }
        if (arbitrary) {
            this.arbitrary = true;
            this.arity = new IntInterval(counter, Integer.MAX_VALUE);
        } else {
            this.arbitrary = false;
            this.arity = new IntInterval(counter, argLists.length);
        }
    }

    public Map<String, String> binding(String name, String ... params) {
        if (!this.arbitrary && this.argLists.length < params.length) {
            throw new ParameterException("Invalid parameter " + name + ": too many arguments");
        }
        LinkedHashMap<String, String> values2 = new LinkedHashMap<String, String>();
        boolean containsEquals = false;
        for (int i = 0; i < params.length; ++i) {
            String keyword;
            String param = params[i];
            int equalSymbolIndex = param.indexOf("=");
            if (equalSymbolIndex != -1) {
                keyword = param.substring(0, equalSymbolIndex);
                if (!this.arbitrary && !this.keywords.contains(keyword)) {
                    if (!containsEquals && !values2.containsKey(keyword = this.argLists[i].keyword)) {
                        values2.put(keyword, param);
                        continue;
                    }
                    throw new ParameterException("Invalid parameter " + name + ": got an unexpected keyword argument '" + keyword + "'");
                }
                containsEquals = true;
                if (values2.containsKey(keyword)) {
                    throw new ParameterException("Invalid parameter " + name + ": keyword argument repeated '" + keyword + "'");
                }
                if (keyword.length() + 1 == param.length()) {
                    values2.put(keyword, "");
                    continue;
                }
                values2.put(keyword, param.substring(equalSymbolIndex + 1));
                continue;
            }
            if (containsEquals) {
                throw new ParameterException("Invalid parameter " + name + ": positional argument follows keyword argument: " + param);
            }
            keyword = this.argLists[i].keyword;
            if (values2.containsKey(keyword)) {
                throw new ParameterException("Invalid parameter " + name + ": keyword argument repeated '" + keyword + "'");
            }
            values2.put(keyword, param);
        }
        for (Param param : this.argLists) {
            if (values2.containsKey(param.keyword)) continue;
            if (param.defaultValue == null) {
                throw new ParameterException("Invalid parameter " + name + ": missing required positional argument '" + param.keyword + "'");
            }
            values2.put(param.keyword, param.defaultValue);
        }
        return values2;
    }

    public IntInterval getArity() {
        return this.arity;
    }

    public String toString(Map<String, String> params) {
        List<String> values2 = new List<String>();
        for (String key : params.keySet()) {
            values2.add(key + "=" + params.get(key));
        }
        return values2.toString(" ");
    }

    static class Param {
        final String keyword;
        final String defaultValue;

        public Param(String arg) {
            if (arg == null) {
                throw new CommandParserException("Invalid dynamic parameter: null");
            }
            if (arg.length() == 0) {
                throw new CommandParserException("Invalid dynamic parameter: '" + arg + "'");
            }
            int index = arg.indexOf("=");
            if (index == -1) {
                this.keyword = arg;
                this.defaultValue = null;
            } else {
                this.keyword = arg.substring(0, index);
                this.defaultValue = index == arg.length() - 1 ? "" : arg.substring(index + 1);
            }
        }

        public String toString() {
            if (this.defaultValue == null) {
                return this.keyword;
            }
            return this.keyword + "=" + this.defaultValue;
        }
    }
}

