/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import java.util.EnumSet;

public abstract class EnumConverter<T extends Enum<T>>
implements IConverter<T> {
    private final Class<T> tClass;

    public EnumConverter(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public T convert(String name, String ... values2) {
        if (values2.length == 1) {
            try {
                try {
                    return Enum.valueOf(this.tClass, values2[0]);
                }
                catch (IllegalArgumentException e) {
                    return Enum.valueOf(this.tClass, values2[0].toUpperCase());
                }
            }
            catch (Exception e) {
                throw new ParameterException("Invalid parameter \"" + name + "\": should be one of the following " + EnumSet.allOf(this.tClass));
            }
        }
        throw new ParameterException(IConverter.getErrorString(name, List.wrap(values2).toString(" "), "an enum (1 positional argument required)"));
    }
}

