/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum FileSizeConverter implements IConverter<Long>
{
    INSTANCE;

    private static final String REGEX = "^\\s*(\\d+(?:\\.\\d+)?)\\s*([BKMGTP]B?)?$";
    private static final Pattern pattern;

    @Override
    public Long convert(String name, String ... values2) {
        Matcher matcher = pattern.matcher(values2[0].toUpperCase().trim());
        if (matcher.matches()) {
            long method;
            long size = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2);
            if (unit == null || unit.equals("B")) {
                method = size;
            } else if (unit.equals("PB") || unit.equals("P")) {
                method = size * 1024L * 1024L * 1024L * 1024L * 1024L;
            } else if (unit.equals("TB") || unit.equals("T")) {
                method = size * 1024L * 1024L * 1024L * 1024L;
            } else if (unit.equals("GB") || unit.equals("G")) {
                method = size * 1024L * 1024L * 1024L;
            } else if (unit.equals("MB") || unit.equals("M")) {
                method = size * 1024L * 1024L;
            } else if (unit.equals("KB") || unit.equals("K")) {
                method = size * 1024L;
            } else {
                throw new ParameterException("Invalid data length: " + values2[0]);
            }
            return method;
        }
        throw new ParameterException("Invalid data length: " + values2[0]);
    }

    static {
        pattern = Pattern.compile(REGEX);
    }
}

