/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum FileSizeFilterConverter implements IConverter<ILongFilter>
{
    INSTANCE;

    private static final String REGEX = "^(!?)(>=|>|==|!=|<=|<)\\s*(\\d+(?:\\.\\d+)?)\\s*([BKMGTP]B?)?$";
    private static final Pattern pattern;

    @Override
    public ILongFilter convert(String name, String ... values2) {
        if (values2.length == 0) {
            return size -> true;
        }
        List<ILongFilter> filters = new List<ILongFilter>();
        for (String value : values2) {
            Matcher matcher = pattern.matcher(value.toUpperCase().trim());
            if (matcher.matches()) {
                long method;
                boolean isNegated = !matcher.group(1).isEmpty();
                String operator = matcher.group(2);
                long size2 = Long.parseLong(matcher.group(3));
                String unit = matcher.group(4);
                if (unit == null || unit.equals("B")) {
                    method = size2;
                } else if (unit.equals("PB") || unit.equals("P")) {
                    method = size2 * 1024L * 1024L * 1024L * 1024L * 1024L;
                } else if (unit.equals("TB") || unit.equals("T")) {
                    method = size2 * 1024L * 1024L * 1024L * 1024L;
                } else if (unit.equals("GB") || unit.equals("G")) {
                    method = size2 * 1024L * 1024L * 1024L;
                } else if (unit.equals("MB") || unit.equals("M")) {
                    method = size2 * 1024L * 1024L;
                } else if (unit.equals("KB") || unit.equals("K")) {
                    method = size2 * 1024L;
                } else {
                    throw new ParameterException("Invalid filter condition: " + value);
                }
                if (operator.equals(">=") && !isNegated || operator.equals("<") && isNegated) {
                    filters.add(l -> l >= method);
                    continue;
                }
                if (operator.equals(">") && !isNegated || operator.equals("<=") && isNegated) {
                    filters.add(l -> l > method);
                    continue;
                }
                if (operator.equals("==") && !isNegated || operator.equals("!=") && isNegated) {
                    filters.add(l -> l == method);
                    continue;
                }
                if (operator.equals("!=") && !isNegated || operator.equals("==") && isNegated) {
                    filters.add(l -> l != method);
                    continue;
                }
                if (operator.equals("<=") && !isNegated || operator.equals(">") && isNegated) {
                    filters.add(l -> l <= method);
                    continue;
                }
                if (operator.equals("<") && !isNegated || operator.equals(">=") && isNegated) {
                    filters.add(l -> l < method);
                    continue;
                }
                throw new ParameterException("Invalid filter condition: " + value);
            }
            throw new ParameterException("Invalid filter condition: " + value);
        }
        if (filters.size() == 1) {
            return (ILongFilter)filters.fastGet(0);
        }
        return l -> {
            for (ILongFilter filter : filters) {
                if (filter.filter(l)) continue;
                return false;
            }
            return true;
        };
    }

    static {
        pattern = Pattern.compile(REGEX);
    }
}

