/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;

public interface IConverter<V> {
    public static String getErrorString(String name, String value, String message) {
        return "Invalid parameter \"" + name + "\": couldn't convert \"" + value + "\" to " + message;
    }

    public static <V> IConverter<V> instanceOf(FieldType type) {
        if (type == FieldType.NULL) {
            return null;
        }
        return (name, values2) -> {
            if (values2.length == 1) {
                return type.char2Object(values2[0]);
            }
            throw new ParameterException(IConverter.getErrorString(name, List.wrap(values2).toString(" "), "a " + type + " (1 positional argument required)"));
        };
    }

    public V convert(String var1, String ... var2);
}

