/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.converter.TextSeparatorConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.util.Map;

public enum TextReaderConverter implements IDynamicConverter<TEntry<TextReader.Builder, Map<String, String>>>
{
    INSTANCE;


    @Override
    public TEntry<TextReader.Builder, Map<String, String>> convert(String name, final Map<String, String> params) {
        try {
            LiveFile file = LiveFile.of(params.get("file"));
            final ISeparator separator = TextSeparatorConverter.INSTANCE.convert(name, params.get("sep"));
            return new TEntry<TextReader.Builder, Map<String, String>>(TextReader.setInput(file).setSeparator(separator).setMetadataParser(new IMetadataParser(){
                final Bytes marker;
                final int count;
                {
                    this.marker = new Bytes((String)params.get("meta-marker"));
                    this.count = Integer.parseInt((String)params.get("meta-count"));
                }

                @Override
                public boolean parse(long pointer, Bytes data, ICCFMeta metas) {
                    if (data.startsWith(this.marker)) {
                        List<Bytes> pairs;
                        if ((data = data.subBytes(this.marker.length()).trim()).length() >= 1) {
                            int index = data.indexOf((byte)61);
                            if (index == -1) {
                                metas.add(CCFMetaItem.of(data.toString()));
                            } else {
                                metas.add(CCFMetaItem.of(data.subBytes(0, index).toString(), data.subBytes(index + 1).toString()));
                            }
                        }
                        if ((pairs = separator.accept(data)).size() != 0) {
                            if (pairs.size() == 1) {
                                if (pairs.fastGet(0).length() > 0) {
                                    metas.add(CCFMetaItem.of(pairs.fastGet(0).toString()));
                                }
                            } else if (pairs.size() == 2) {
                                metas.add(CCFMetaItem.of(pairs.fastGet(0).toString(), pairs.fastGet(1).toString()));
                            } else {
                                throw new ParameterException("Invalid META format specified: '{}' can only be used zero or once for key-value pairs");
                            }
                        }
                        return true;
                    }
                    return pointer < (long)this.count;
                }
            }).setHeaderParser(new IHeaderParser(){
                final boolean absent;
                {
                    this.absent = Boolean.parseBoolean((String)params.get("header-absent"));
                }

                @Override
                public boolean parse(Bytes data, ISeparator separator, IndexableSet<String> header) {
                    if (this.absent) {
                        boolean isHeader = IHeaderParser.NO_HEADER_LINE.parse(data, separator, header);
                        if (((String)params.get("header")).length() > 0) {
                            int count = header.size();
                            header.clear();
                            List<String> headers = List.wrap(((String)params.get("header")).split(","));
                            for (String name : headers) {
                                if (name == null || name.length() == 0) {
                                    name = "_";
                                }
                                if (header.contains(name)) {
                                    int dupIndex = 1;
                                    while (header.contains(name = (name.endsWith("_") ? "" : "_") + dupIndex)) {
                                        ++dupIndex;
                                    }
                                }
                                header.add(name);
                            }
                            if (header.size() != count) {
                                throw new RuntimeException("The row contains " + count + " field values, while the header specifies (by 'header=') " + header.size() + " fields: \n" + header);
                            }
                        }
                        return isHeader;
                    }
                    boolean isHeader = IHeaderParser.beginWith((String)params.get("header-marker"), true).parse(data, separator, header);
                    if (((String)params.get("header")).length() > 0) {
                        int count = header.size();
                        header.clear();
                        List<String> headers = List.wrap(((String)params.get("header")).split(","));
                        for (String name : headers) {
                            if (name == null || name.length() == 0) {
                                name = "_";
                            }
                            if (header.contains(name)) {
                                int dupIndex = 1;
                                while (header.contains(name = (name.endsWith("_") ? "" : "_") + dupIndex)) {
                                    ++dupIndex;
                                }
                            }
                            header.add(name);
                        }
                        if (header.size() != count) {
                            throw new RuntimeException("The row contains " + count + " field values, while the header specifies (by 'header=') " + header.size() + " fields: " + header);
                        }
                    }
                    return isHeader;
                }
            }), params);
        }
        catch (Error | Exception e) {
            throw new ParameterException(e.getMessage());
        }
    }
}

