/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.converter;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.utils.Assert;

public enum TextSeparatorConverter implements IConverter<ISeparator>
{
    INSTANCE;


    @Override
    public ISeparator convert(String name, String ... values2) {
        ISeparator separator;
        Assert.that(values2.length == 1);
        switch (values2[0]) {
            case "TAB": 
            case "\t": {
                separator = Separator.TAB;
                break;
            }
            case "COMMA": 
            case ",": {
                separator = Separator.COMMA;
                break;
            }
            case "SEMICOLON": 
            case ";": {
                separator = Separator.SEMICOLON;
                break;
            }
            case "UNIVERSAL": {
                separator = Separator.UNIVERSAL;
                break;
            }
            case "BLANK": 
            case " ": {
                separator = Separator.BLANK;
                break;
            }
            case "MULTI_BLANK": {
                separator = Separator.MULTI_BLANK;
                break;
            }
            case "BDD": {
                separator = Separator.BDD;
                break;
            }
            case "CDD": {
                separator = Separator.CDD;
                break;
            }
            case "SDD": {
                separator = Separator.SDD;
                break;
            }
            case "NONE": {
                separator = Separator.NONE;
                break;
            }
            default: {
                separator = new CustomSeparator(values2[0]);
            }
        }
        return separator;
    }
}

