/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.example;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.io.file.HTTPFile;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.utils.Downloader;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="download <url> [options]", usage_item={@UsageItem(key="About", value={"Download resource files from specified HTTP/HTTPS/SFTP address."})})
public class DownloaderProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloaderProgram.class);
    @Option(names={"download"}, type=FieldType.string, required=true)
    String address;
    @Option(names={"--output", "-o"}, type=FieldType.file)
    @OptionUsage(description={"Specify the output file path."})
    File output;
    @Option(names={"--disable-resume"}, type=FieldType.NULL)
    @OptionUsage(description={"Disable resumable transfers."})
    boolean resume = true;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--proxy", "-p"}, type=FieldType.ipsocket)
    @OptionUsage(description={"Set the proxy to access the target resource."}, item={@UsageItem(key="Example", value={"--proxy localhost:7890"})})
    InetSocketAddress proxy = null;
    @Option(names={"--timeout"}, type=FieldType.varInt32)
    @OptionUsage(defaultTo="60", description={"Disconnect if the server does not respond for more than the specified timeout in seconds."})
    int timeout = 60;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        DownloaderProgram program = new DownloaderProgram();
        if (args.length == 1 && args[0].equals("download")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        LOGGER.info("\n{}", (Object)options);
        LiveFile url = program.address.startsWith("http://") || program.address.startsWith("https://") ? new HTTPFile(new URL(program.address), program.proxy, program.timeout) : LiveFile.of(program.address);
        File output = program.output == null ? new File(RuntimeProperty.WORKSPACE_PATH, url.getName()) : program.output;
        Downloader downloader = new Downloader(url, output).resume(program.resume).setThreads(program.threads);
        downloader.download();
        LOGGER.info("The requested file '{}' ({}) download is complete", (Object)output, (Object)new LocalFile(output).formatLength(null));
    }
}

