/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.example;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.IRangeValidator;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import edu.sysu.pmglab.progressbar.unit.DataLengthUnit;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="gzip2bgzip <input> -o <output> [options]", usage_item={@UsageItem(key="About", value={"Converts GZIP-compressed files to BGZIP-compressed files, enabling multi-threaded processing."})})
public class Gzip2BgzipProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(Gzip2BgzipProgram.class);
    @Option(names={"gzip2bgzip"}, type=FieldType.livefile, required=true)
    LiveFile input;
    @Option(names={"--output", "-o"}, type=FieldType.file, required=true)
    @OptionUsage(description={"Specify the output file path."})
    File output;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--level", "-l"}, type=FieldType.varInt32, validator=CompressionLevelRangeValidator.class)
    @OptionUsage(description={"Compression level to use when compressing; 0 to 9."}, defaultTo="5")
    int level = 5;

    public static void main(String[] args) throws IOException {
        int length;
        Gzip2BgzipProgram program = new Gzip2BgzipProgram();
        CommandOptions options = program.parse(args);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        ReaderStream reader = program.input.openAsText();
        IBGZIPWriterStream writer = IBGZIPWriterStream.instanceOf(program.output, program.level, program.threads);
        byte[] buffer = new byte[8192];
        ProgressBar bar = new ProgressBar.Builder().setTextRenderer("Compressed", DataLengthUnit.B).setConsumer(new ConsoleConsumer()).build();
        while ((length = reader.read(buffer)) != -1) {
            bar.step(length);
            writer.write(buffer, 0, length);
        }
        bar.close();
        writer.close();
        ((IReaderStream)reader).close();
    }

    private static enum CompressionLevelRangeValidator implements IRangeValidator<Integer>
    {
        INSTANCE;


        @Override
        public Interval<Integer> range() {
            return new Interval<Integer>(0, 9);
        }
    }
}

