/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.example;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.utils.MD5;
import edu.sysu.pmglab.utils.StringFormatter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="md5 <input> <input> ...", usage_item={@UsageItem(key="About", value={"Calculate the message digest fingerprint (checksum) for the specified file(s)."})})
public class MD5Program
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(MD5Program.class);
    @Option(names={"md5"}, type=FieldType.livefile, container=Container.LIST)
    List<LiveFile> inputs = new List(0);
    @Option(names={"--format", "-f"})
    @OptionUsage(description={"Format output using a custom template.", "The following placeholders are supported for substitution:\n* {name} - The name of the file.\n* {path} - The full path to the file.\n* {type} - The type of the file.\n* {size} - The size of the file.\n* {size.format} - The formatted size of the file.\n* {modifyTime} - The last modification time of the file.\n* {modifyTime.format} - The formatted last modification time of the file.\n* {value} - The MD5 checksum of the file."}, defaultTo="MD5 ({path}) = {value}")
    String rule = "MD5 ({path}) = {value}";

    public static void main(String[] args) throws IOException {
        MD5Program program = new MD5Program();
        CommandOptions options = program.parse(args);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        StringFormatter formatter = new StringFormatter(program.rule);
        for (LiveFile path : program.inputs) {
            ISeekableReaderStream reader = path.openAsBinary();
            Throwable throwable = null;
            try {
                String md5Code = MD5.check(reader);
                formatter.format("name", path.getName());
                formatter.format("path", path.getPath());
                formatter.format("type", (Object)path.getFileType());
                formatter.format("size", path.length());
                formatter.format("size.format", path.formatLength(null));
                formatter.format("modifyTime", path.lastModifyTime());
                formatter.format("modifyTime.format", path.formatLastModifyTime(null));
                formatter.format("value", md5Code);
                System.out.println(formatter);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }
}

