/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.commandParser.rule;

import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.exception.CommandParserException;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.rule.IRule;

public class ChainRule
implements IRule {
    final IRule[] items;

    public ChainRule(IRule ... rules) {
        if (rules == null || rules.length == 0) {
            throw new CommandParserException("Invalid rule: no items specified");
        }
        this.items = new IRule[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i] == null) {
                throw new CommandParserException("Invalid rule: null rule object");
            }
            this.items[i] = rules[i];
        }
    }

    public ChainRule(String ... items) {
        if (items == null || items.length == 0) {
            throw new CommandParserException("Invalid rule: no items specified");
        }
        this.items = new IRule[items.length];
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.items[i] = options -> options.passed(item);
        }
    }

    @Override
    public void validate(CommandOptions options) throws ParameterException {
        if (!this.filter(options)) {
            throw new ParameterException(this.toString());
        }
    }

    @Override
    public boolean filter(CommandOptions options) {
        for (int i = 0; i < this.items.length - 1; ++i) {
            if (this.items[i].filter(options)) continue;
            return true;
        }
        return this.items[this.items.length - 1].filter(options);
    }
}

